/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.repository;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jorphan.gui.ComponentUtil;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.jmeterplugins.repository.GenericCallback;
import org.jmeterplugins.repository.Plugin;
import org.jmeterplugins.repository.PluginCheckbox;
import org.jmeterplugins.repository.PluginManager;
import org.jmeterplugins.repository.PluginManagerMenuItem;
import org.jmeterplugins.repository.PluginUpgradesList;
import org.jmeterplugins.repository.PluginsList;

public class PluginManagerDialog
extends JDialog
implements ActionListener,
ComponentListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final Border SPACING = BorderFactory.createEmptyBorder(5, 5, 5, 5);
    private final PluginManager manager;
    private final JTextPane modifs = new JTextPane();
    private final JButton apply = new JButton("Apply Changes and Restart JMeter");
    private final PluginsList installed;
    private final PluginsList available;
    private final PluginUpgradesList upgrades;
    private final JSplitPane topAndDown = new JSplitPane(0);
    private JLabel statusLabel = new JLabel("");
    private JTextArea failureLabel = new JTextArea();

    public PluginManagerDialog(PluginManager aManager) {
        super((Frame)null, "JMeter Plugins Manager", true);
        this.setLayout(new BorderLayout());
        this.addComponentListener(this);
        this.manager = aManager;
        Dimension size = new Dimension(1024, 768);
        this.setSize(size);
        this.setPreferredSize(size);
        this.setIconImage(PluginManagerMenuItem.getPluginsIcon().getImage());
        ComponentUtil.centerComponentInWindow((Component)this);
        this.failureLabel.setForeground(Color.RED);
        this.failureLabel.setEditable(false);
        this.add((Component)this.failureLabel, "North");
        final GenericCallback<Object> statusRefresh = new GenericCallback<Object>(){

            @Override
            public void notify(Object ignored) {
                String changeText = PluginManagerDialog.this.manager.getChangesAsText();
                PluginManagerDialog.this.modifs.setText(changeText);
                PluginManagerDialog.this.apply.setEnabled(!changeText.isEmpty() && PluginManagerDialog.this.installed.isEnabled());
            }
        };
        ChangeListener cbNotifier = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() instanceof PluginCheckbox) {
                    PluginCheckbox checkbox = (PluginCheckbox)e.getSource();
                    Plugin plugin = checkbox.getPlugin();
                    PluginManagerDialog.this.manager.toggleInstalled(plugin, checkbox.isSelected());
                    statusRefresh.notify(this);
                }
            }
        };
        ChangeListener cbUpgradeNotifier = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() instanceof PluginCheckbox) {
                    PluginCheckbox checkbox = (PluginCheckbox)e.getSource();
                    Plugin plugin = checkbox.getPlugin();
                    if (checkbox.isSelected()) {
                        plugin.setCandidateVersion(checkbox.getPlugin().getMaxVersion());
                    } else {
                        plugin.setCandidateVersion(checkbox.getPlugin().getInstalledVersion());
                    }
                    statusRefresh.notify(this);
                }
            }
        };
        this.installed = new PluginsList(this.manager.getInstalledPlugins(), cbNotifier, statusRefresh);
        this.available = new PluginsList(this.manager.getAvailablePlugins(), cbNotifier, statusRefresh);
        this.upgrades = new PluginUpgradesList(this.manager.getUpgradablePlugins(), cbUpgradeNotifier, statusRefresh);
        this.topAndDown.setResizeWeight(0.75);
        this.topAndDown.setDividerSize(5);
        this.topAndDown.setTopComponent(this.getTabsPanel());
        this.topAndDown.setBottomComponent(this.getBottomPanel());
        this.add((Component)this.topAndDown, "Center");
        statusRefresh.notify(this);
    }

    private Component getTabsPanel() {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Installed Plugins", this.installed);
        tabbedPane.addTab("Available Plugins", this.available);
        tabbedPane.addTab("Upgrades", this.upgrades);
        return tabbedPane;
    }

    private JPanel getBottomPanel() {
        this.apply.setEnabled(false);
        this.modifs.setEditable(false);
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(2));
        JPanel panel = new JPanel(new BorderLayout());
        JPanel modifsPanel = new JPanel(new BorderLayout());
        modifsPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.getHeight() / 3));
        modifsPanel.setPreferredSize(new Dimension(this.getWidth(), this.getHeight() / 3));
        modifsPanel.setBorder(SPACING);
        modifsPanel.setBorder(BorderFactory.createTitledBorder("Review Changes"));
        this.modifs.setEditable(false);
        modifsPanel.add((Component)new JScrollPane(this.modifs), "Center");
        panel.add((Component)modifsPanel, "Center");
        JPanel btnPanel = new JPanel(new BorderLayout());
        btnPanel.setBorder(SPACING);
        btnPanel.add((Component)this.apply, "East");
        btnPanel.add((Component)this.statusLabel, "Center");
        panel.add((Component)btnPanel, "South");
        this.apply.addActionListener(this);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new Thread(){

            @Override
            public void run() {
                PluginManagerDialog.this.installed.setEnabled(false);
                PluginManagerDialog.this.available.setEnabled(false);
                PluginManagerDialog.this.upgrades.setEnabled(false);
                PluginManagerDialog.this.apply.setEnabled(false);
                GenericCallback<String> statusChanged = new GenericCallback<String>(){

                    @Override
                    public void notify(String s) {
                        PluginManagerDialog.this.statusLabel.setText(s);
                        PluginManagerDialog.this.repaint();
                    }
                };
                try {
                    PluginManagerDialog.this.manager.applyChanges(statusChanged);
                    ActionRouter.getInstance().actionPerformed(new ActionEvent(this, 0, "exit"));
                }
                catch (Exception ex) {
                    statusChanged.notify("Failed to apply changes: " + ex.getMessage());
                    throw ex;
                }
            }
        }.start();
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent evt) {
        try {
            this.manager.load();
        }
        catch (Throwable e) {
            log.error("Failed to load plugins manager", e);
            ByteArrayOutputStream text = new ByteArrayOutputStream(4096);
            e.printStackTrace(new PrintStream(text));
            this.failureLabel.setText(text.toString());
        }
        this.topAndDown.setVisible(!this.manager.allPlugins.isEmpty());
        this.failureLabel.setVisible(this.manager.allPlugins.isEmpty());
        this.pack();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }
}

