/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.repository;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.jmeterplugins.repository.CheckBoxList;
import org.jmeterplugins.repository.GenericCallback;
import org.jmeterplugins.repository.Plugin;
import org.jmeterplugins.repository.PluginCheckbox;
import org.jmeterplugins.repository.PluginManagerDialog;

public class PluginsList
extends JPanel
implements ListSelectionListener,
HyperlinkListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final JTextPane description = new JTextPane();
    private JList<PluginCheckbox> list = new CheckBoxList<PluginCheckbox>(5);
    private DefaultListModel<PluginCheckbox> listModel = new DefaultListModel();
    protected final JComboBox<String> version = new JComboBox();
    private ItemListener itemListener = new VerChoiceChanged();
    private GenericCallback<Object> dialogRefresh;

    public PluginsList(Set<Plugin> plugins, ChangeListener checkboxNotifier, GenericCallback<Object> dialogRefresh) {
        super(new BorderLayout(5, 0));
        this.dialogRefresh = dialogRefresh;
        this.description.setContentType("text/html");
        this.description.setEditable(false);
        this.description.addHyperlinkListener(this);
        this.list.setModel(this.listModel);
        this.list.setBorder(PluginManagerDialog.SPACING);
        this.list.addListSelectionListener(this);
        this.add((Component)new JScrollPane(this.list), "West");
        this.add((Component)this.getDetailsPanel(), "Center");
        for (Plugin plugin : plugins) {
            this.listModel.addElement(this.getCheckboxItem(plugin, checkboxNotifier));
        }
        this.list.setComponentPopupMenu(new ToggleAllPopupMenu());
    }

    private JPanel getDetailsPanel() {
        JPanel detailsPanel = new JPanel(new BorderLayout());
        detailsPanel.add((Component)new JScrollPane(this.description), "Center");
        this.version.setEnabled(false);
        JPanel verPanel = new JPanel(new BorderLayout());
        verPanel.add((Component)new JLabel("Version: "), "West");
        verPanel.add(this.version, "Center");
        detailsPanel.add((Component)verPanel, "South");
        return detailsPanel;
    }

    protected PluginCheckbox getCheckboxItem(Plugin plugin, ChangeListener changeNotifier) {
        PluginCheckbox element = new PluginCheckbox(plugin.getName());
        element.setSelected(plugin.isInstalled());
        element.setPlugin(plugin);
        element.addChangeListener(changeNotifier);
        return element;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && this.list.getSelectedIndex() >= 0) {
            Plugin plugin = this.list.getSelectedValue().getPlugin();
            this.description.setText(this.getDescriptionHTML(plugin));
            this.setUpVersionsList(this.list.getSelectedValue());
        }
    }

    protected void setUpVersionsList(PluginCheckbox cb) {
        this.version.removeItemListener(this.itemListener);
        this.version.removeAllItems();
        for (String ver : cb.getPlugin().getVersions()) {
            this.version.addItem(ver);
        }
        this.version.setSelectedItem(this.getCbVersion(cb));
        this.version.setEnabled(this.version.getItemCount() > 1);
        this.version.addItemListener(this.itemListener);
    }

    protected String getCbVersion(PluginCheckbox cb) {
        Plugin plugin = cb.getPlugin();
        if (plugin.isInstalled()) {
            return plugin.getInstalledVersion();
        }
        return plugin.getCandidateVersion();
    }

    private String getDescriptionHTML(Plugin plugin) {
        Map<String, String> libs;
        Set<String> deps;
        String txt = "<h1>" + plugin.getName() + "</h1>";
        if (plugin.isUpgradable()) {
            txt = txt + "<p><font color='orange'>This plugin can be upgraded to version " + plugin.getMaxVersion() + "</font></p>";
        }
        if (!plugin.getVendor().isEmpty()) {
            txt = txt + "<p>Vendor: <i>" + plugin.getVendor() + "</i></p>";
        }
        if (!plugin.getDescription().isEmpty()) {
            txt = txt + "<p>" + plugin.getDescription() + "</p>";
        }
        if (!plugin.getHelpLink().isEmpty()) {
            txt = txt + "<p>Documentation: <a href='" + plugin.getHelpLink() + "'>" + plugin.getHelpLink() + "</a></p>";
        }
        if (!plugin.getScreenshot().isEmpty()) {
            txt = txt + "<p><img src='" + plugin.getScreenshot() + "'/></p>";
        }
        if (plugin.getInstalledPath() != null) {
            txt = txt + "<pre>Location: " + plugin.getInstalledPath() + "</pre>";
        }
        if (!(deps = plugin.getDepends()).isEmpty()) {
            txt = txt + "<pre>Dependencies: " + Arrays.toString(deps.toArray(new String[0])) + "</pre>";
        }
        if (!(libs = plugin.getLibs(plugin.getCandidateVersion())).isEmpty()) {
            txt = txt + "<pre>Libraries: " + Arrays.toString(libs.keySet().toArray(new String[0])) + "</pre>";
        }
        return txt + "<br/>";
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            PluginsList.openInBrowser(e.getURL().toString());
        }
    }

    public static void openInBrowser(String string) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(new URI(string));
            }
            catch (IOException | URISyntaxException ignored) {
                log.debug("Failed to open in browser", (Throwable)ignored);
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.list.setEnabled(enabled);
        this.version.setEnabled(enabled);
    }

    private class ToggleAllPopupMenu
    extends JPopupMenu
    implements ActionListener {
        public ToggleAllPopupMenu() {
            super("Toggle All");
            JMenuItem menuItem = new JMenuItem("Toggle All");
            menuItem.addActionListener(this);
            this.add(menuItem);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (Object a : PluginsList.this.listModel.toArray()) {
                if (!(a instanceof PluginCheckbox)) continue;
                PluginCheckbox cb = (PluginCheckbox)a;
                cb.doClick();
            }
            PluginsList.this.list.repaint();
        }
    }

    private class VerChoiceChanged
    implements ItemListener {
        private VerChoiceChanged() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            if (event.getStateChange() == 1 && event.getItem() instanceof String) {
                String item = (String)event.getItem();
                Plugin plugin = ((PluginCheckbox)PluginsList.this.list.getSelectedValue()).getPlugin();
                plugin.setCandidateVersion(item);
                PluginsList.this.dialogRefresh.notify(this);
            }
        }
    }
}

