package br.ufrgs.inf.prosoft.adaptivecaching.analysis.decision.flowchart.stats;

import br.ufrgs.inf.prosoft.adaptivecaching.analysis.decision.flowchart.FlowchartWorkFlow;
import br.ufrgs.inf.prosoft.adaptivecaching.analysis.decision.flowchart.model.MethodStats;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.metadata.MethodInfo;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.cache.CacheInfo;
import org.ehcache.sizeof.SizeOf;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Optional;

public class CacheabilityMetrics {

    private static SizeOf sizeOf = SizeOf.newInstance();

    //total da população
    public static long sampleSize(long N, double Z, double e) {
        //Nível de confiança 90% -> Z=1.645
        //Nível de confiança 95% -> Z=1.96
        //Nível de confiança 99% -> Z=2.575
        //Qual o nível de certeza que precisa ter de que a amostra retrata com precisão a sua população?
        //double Z = 2.575;

        //e = É a margem de erro máximo que eu quero admitir (p.e. 5%)
        //Qual o nível de certeza que precisa ter de que os traces refletem as execuções da sua aplicação?
        //double e = 0.03;

        //p = É a proporção que esperamos encontrar. Este parâmetro tende confundir bastante à primeira vista:
        double p = 0.5;

        long n = (long) ((N * Math.pow(Z, 2) * p * (1 - p)) /
                ((N - 1) * Math.pow(e, 2) + Math.pow(Z, 2) * p * (1 - p)));


        //simplified without the population
        //int nn = (int) ((Math.pow(Z,2) * p * (1-p)) / Math.pow(e,2));
        return n;
    }

    public static Optional<Boolean> isStaticData(MethodStats methodStats, FlowchartWorkFlow workflow, int population) {

        //executions of a method should represent a good portion of total logs in order to avoid 1 occur == 100% hit
        if (!(methodStats.getNumberOfSameOccurrences() >= sampleSize(methodStats.getNumberOfOccurrences(), 1.645, 0.05)
                && methodStats.getNumberOfOccurrences() >= sampleSize(population, 1.645, 0.05))) {
            return Optional.empty();
        }

        if (methodStats.hitRatio() == 100.0)
            return Optional.of(true);
        else
            return Optional.of(false);
    }

    public static Optional<Boolean> changeMoreThanUsed(MethodStats methodStats, FlowchartWorkFlow workflow) {
        //+/- k sds
        if (methodStats.missRatio() > workflow.missThreshold(0))
            return Optional.of(true);
        else
            return Optional.of(false);
    }

    public static Optional<Boolean> usedByManyRequests(MethodStats methodStats, FlowchartWorkFlow workflow, int population) {

        //same executions of a method should represent a good portion of total execution of such method
        if (methodStats.getNumberOfOccurrences() >= sampleSize(population, 2.575, 0.03)) {
            return Optional.of(true);
        } else return Optional.empty();
    }

    public static Optional<Boolean> isUserSpecific(MethodStats methodStats, FlowchartWorkFlow workflow) {

        if (methodStats.getAmountOfIdentifiedSameOccurences() == 0)
            return Optional.empty();

        //the less shareable, the more user specific
        if (methodStats.shareability() < workflow.shareabilityThreshold(0))
            return Optional.of(true);
        else
            return Optional.of(false);
    }

    public static Optional<Boolean> isCacheSizeLarge(CacheInfo cacheInfo) {

        //TODO concept considered while caching
        if (true)
            return Optional.of(true);


        //unbounded cache size
        if (cacheInfo.getTotalSpace() == null)
            return Optional.of(true);

        BigDecimal bd = new BigDecimal(cacheInfo.getFreeSpace())
                .multiply(new BigDecimal(100))
                .divide(new BigDecimal(cacheInfo.getTotalSpace()), 5, RoundingMode.HALF_UP);

        double freePercent = bd.doubleValue();

        if (freePercent >= 20.0)
            return Optional.of(true);
        else
            return Optional.of(false);
    }

    public static Optional<Boolean> isDataSizeLarge(CacheInfo cacheInfo, MethodInfo methodInfo) {

        //TODO concept considered while caching
        if (true)
            return Optional.of(false);

        if (cacheInfo.getTotalSpace() == null)
            return Optional.empty();

        long shallowSize = sizeOf.sizeOf(methodInfo.getReturnedValue());

        BigDecimal bd = new BigDecimal(shallowSize)
                .multiply(new BigDecimal(100))
                .divide(new BigDecimal(cacheInfo.getFreeSpace()), 5, RoundingMode.HALF_UP);
        double dataSizePercent = bd.doubleValue();

        if (dataSizePercent <= 2.0)
            return Optional.of(false);
        else return Optional.of(true);
    }

    public static Optional<Boolean> isExpensive(MethodStats methodStats, FlowchartWorkFlow workflow) {
        if (methodStats.getSameOccurrencesAverageExecutionTime() >= workflow.expensivenessThreshold(0))
            return Optional.of(true);
        else
            return Optional.of(false);
    }

    public static String allMetricsToString(CacheInfo cacheInfo, MethodInfo methodInfo, MethodStats methodStats, FlowchartWorkFlow workflow, int population) {
        //isStaticData,changeMoreThanUsed,usedByManyRequests,isUserSpecific,isCacheSizeLarge,isDataSizeLarge,isExpensive
        return isStaticData(methodStats, workflow, population) +
                "," + changeMoreThanUsed(methodStats, workflow) +
                "," + usedByManyRequests(methodStats, workflow, population) +
                "," + isUserSpecific(methodStats, workflow) +
                "," + isCacheSizeLarge(cacheInfo) +
                "," + isDataSizeLarge(cacheInfo, methodInfo) +
                "," + isExpensive(methodStats, workflow)
                ;
    }
}
