/*
 * Copyright 2002-2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.model;

import java.util.Collection;

/**
 * Spring's central model manager SPI.
 * Allows for retrieving named {@link Cache} regions.
 *
 * @author Costin Leau
 * @since 3.1
 */
public interface CacheManager {

    /**
     * Return the model associated with the given name.
     *
     * @param name the model identifier (must not be {@code null})
     * @return the associated model, or {@code null} if none found
     */
    Cache getCache(String name);

    /**
     * Return a collection of the model names known by this manager.
     *
     * @return the names of all caches known by the model manager
     */
    Collection<String> getCacheNames();
}
