Seamless and adaptive application-level caching
=========

Meeting performance and scalability requirements while delivering services is a critical issue in web applications. Recently, latency and cost of Internet-based services are encouraging the use of application-level caching to continue satisfying users' demands and improve the scalability and availability of origin servers. Application-level caching, in which developers manually control cached content, has been adopted when traditional forms of caching are insufficient to meet such requirements. Despite its popularity, this level of caching is typically addressed in an ad-hoc way, given that it depends on specific details of the application. Furthermore, it forces application developers to reason about a crosscutting concern, which is unrelated to the application business logic. As a result, application-level caching is a time-consuming and error-prone task, becoming a common source of bugs. Among all the issues involved with application-level caching, the decision of what should be cached must frequently be adjusted to cope with the application evolution and usage, making it a challenging task.

Application-level caching is mainly characterized by caching techniques employed along with the application code, i.e. business, presentation and data logic. Therefore, it is not tied up to a specific caching location (server-side, proxy or client-side), because it can be conceived at the server-side, to speed up a Java-based application that produces HTML pages sent to users, as well as at the client-side, as a JavaScript-based application that executes part of its logic directly on the client's browser. In both situations, developers can reason about caching and implement a caching logic to satisfy their needs.

Evaluation set up - Identifying cacheable methods automatically
---------

Simulations were performed using three different caching configurations: (i) no application-level caching (NO), (ii) application-level caching manually designed and implemented by developers (DEV); and (iii) our approach (AP).

######## Set up
- Three applications
- Three set ups for each application: NO, DEV, AP
- A simulation of a randomized workload for each set up

Required Tools
---------
- [Jmeter 3.3] (http://jmeter.apache.org/)
- MySQL
- Java 8
- Maven 3

Applications
---------

To prevent application bias in our results, we selected applications with different sizes (6.3--111.3 KLOC) and domains.

Our evaluation was performed with three open-source web applications:
- [Cloud Store] (http://www.cloudscale-project.eu/)
- [Spring petclinic] (https://github.com/SpringSource/spring-petclinic/)
- [Shopizer] (https://github.com/shopizer-ecommerce/shopizer)

Application's setup
-------------------

###### Requirements

- Java 8
- Maven 3
- Mysql database

[Shopizer] (https://github.com/shopizer-ecommerce/shopizer):

This application requires the installation of Elasticsearch (https://www.elastic.co/) to run properly.

Installation and configuration:
- Create schema `SALESMANAGER` on the database
- Configure the file `database.properties` with your database info
- Database population: in the file `shopizer-properties.xml` there is the tag `<prop key="POPULATE_TEST_DATA">true</prop>`. For AP and DEV, such configuration will provide 7 categories, 6 products, addresses USA, one customer, one admin, shipping info in the database in the first initialization of the system. For NO, it will be generated a lot of more randomized data. For more information on how the database is populated, please refer to `InitData.class` and its implementations.
- Compile and run: `mvn clean install tomcat7:run-war -DskipTests`

Use the urls below to access system's features
- http://localhost:8080/sm-shop/<profile>
- /shop → Store page
- /admin → Administration page where the login and password are: admin:password

[Petclinic] (https://github.com/spring-projects/spring-petclinic)

Installation and configuration:
- Create schema `perclinic` on the database
- Configure database on the file `pom.xml`
- Populate database: on the first initialization it will be populated automatically
- Compile and run: `mvn clean install tomcat7:run-war -DskipTests`
- Url to access the system: http://localhost:9966/petclinic/

[CloudStore] (https://github.com/CloudScale-Project/CloudStore)

Installation and configuration:
- Restore the [dump](https://github.com/CloudScale-Project/CloudStore) located in `DEV/database/rds-tpcw-dump-latest.sql`, such dump has 10000 books
- Configure database on file `src/main/resources/database/database.hibernate.properties`
- Compile and run: `mvn clean install tomcat7:run-war -DskipTests`
- Url to access the system: http://localhost:8080/showcase/

Simulations
-----------

Our simulation emulated client sessions to exercise applications and evaluate decision criteria. Simulations consisted of 50 simultaneous users constantly navigating through the application, at a limit of 1000 requests per user.

Each emulated client navigates from an application page to another, randomly selecting the next page from those accessible from the current page. The navigation process starts on the application home page. Emulated clients thus follow the same navigation rules of a real user.

After run the application, JMeter is used to simulate load. Thus, open Jmeter, load the simulation setup according to the application that should be evaluated.

Metrics
-----------

To assess performance, we used two metrics: throughput (number of requests handled per second) and hit ratio, because they are well-known in the context of web applications and cache performance tests.

- Throughput is obtained from Jmeter reports
- Hit absolute and Hit ratio can be acquired from `jconsole` after the end of the simulation. Such metrics will be presented at EhCache → Estatistics → <cache name>