#!/bin/bash

#start services manually in advance
#mongod &
#sudo service mysql start

applicationfolder="~/workspace/adaptive-caching-framework/evaluation/Applications/"
#configs=("NO" "DEV" "AP")
configs=("NO")
workloadfolder="~/workspace/adaptive-caching-framework/evaluation/JMeter/"
jmeter="~/dev/apache-jmeter-3.0/bin/jmeter"

## take care of the order
#applications=("CloudStore" "shopizer/sm-shop" "spring-petclinic")
#databases=("CloudStore" "shopizer/sm-shop" "spring-petclinic")
#workloads=("cloudscale-sustain.jmx" "Shopizer.jmx" "petclinic_test_plan.jmx")
applications=("CloudStore")
#databases=("petclinic")
workloads=("cloudscale-sustain.jmx")


numberOfExecutions=1
for (( i=1; i <= $numberOfExecutions; ++i ))
do
	## now loop through the above array
	for config in "${configs[@]}"
	do
		for iapp in "${!applications[@]}"
		do
			echo "Processing execution $i of ${applications[$iapp]}-$config"
			echo "Killing any process up into port 8080..."
			fuser -k 8080/tcp1
			echo "Killing any process up into port 8080... done"

			## setup database (clean, create, populate)
			##todo run database config as a script
			#echo "drop database ${databases[$iapp]}" | mysql -u "root" "-proot"
			#echo "create database ${databases[$iapp]}" | mysql -u "root" "-proot"

			## enter the folder
			echo "Entering into $applicationfolder$config/${applications[$iapp]}..."
			cd "$applicationfolder$config/${applications[$iapp]}"

			## compile and run web server
			echo "Running tomcat..."
			mvn clean install tomcat7:run-war -DskipTests -q & mvnpid=$!
			echo "Running tomcat... done"

			## wait for maven to compile and tomcat to run
			echo "Waiting until tomcat is up..."
			sleep 10s
			echo "Waiting until tomcat is up... done"

			## run jmeter
			echo "Running jmeter..."
			sh $jmeter -n -t $workloadfolder${workloads[$iapp]}
			echo "Running jmeter... done"

			## copy jmeter results
			echo "Copying and renaming results of execution $i of ${applications[$iapp]}-$config..."
			mv ~/Desktop/report.csv ~/Desktop/${applications[$iapp]}-$config-$i.csv
			echo "Copying and renaming results of execution $i of ${applications[$iapp]}-$config... done"

			## kill maven after all
			kill -9 $mvnpid
		done
	done
done

#TRP: (N-samples/(timestamp_fim-timestap_ini))*1000
