package br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.model;

import java.util.Collection;

/**
 * The interface Cache manager.
 */
public interface CacheManager {

    /**
     * Return the model associated with the given name.
     *
     * @param name the model identifier (must not be {@code null})
     * @return the associated model, or {@code null} if none found
     */
    Cache getCache(String name);

    /**
     * Return a collection of the model names known by this manager.
     *
     * @return the names of all caches known by the model manager
     */
    Collection<String> getCacheNames();
}
