package org.springframework.samples.petclinic;

import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.AdaptiveCaching;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.types.CacheProviderType;
import br.ufrgs.inf.prosoft.tigris.configuration.annotation.ComponentScan;
import br.ufrgs.inf.prosoft.tigris.configuration.annotation.TigrisConfiguration;
import br.ufrgs.inf.prosoft.tigris.configuration.types.Modelling;
import br.ufrgs.inf.prosoft.tigris.configuration.types.RepositoryType;
import br.ufrgs.inf.prosoft.tigris.sampling.GranularityType;
import br.ufrgs.inf.prosoft.tigris.sampling.SamplingConfiguration;

@TigrisConfiguration(
    logRepository = RepositoryType.MEMORY,
    staticMetricFile = "petclinic.csv",
    criteria = "more frequent OR more expensive")
@SamplingConfiguration(granularity = GranularityType.METHOD, samplingPercentage = 50)
@AdaptiveCaching(cacheProvider = CacheProviderType.EHCACHE,
    modelling = Modelling.FULLEXPLORATION, disableMonitoringAfterAnalysis = false,
    analyzeOnce = true, expiryInterval = 60)
@ComponentScan(allowed = "org.springframework.samples.petclinic.*", denied = "org.springframework.samples.petclinic.model.*")
public class Configuration {
}
