package br.ufrgs.inf.prosoft.adaptivecaching.analysis.trigger;

import redis.clients.jedis.Client;
import redis.clients.jedis.JedisMonitor;

public class MyJedisMonitor extends JedisMonitor {

    @Override
    public void proceed(Client client) {
        this.client = client;
        this.client.setTimeoutInfinite();
        do {
            String command = client.getBulkReply();

            if (command.contains("\"SET\""))
                onSet(command);
            else if (command.contains("\"GET\""))

                onCommand(command);
        } while (client.isConnected());
    }

    private void onSet(String command) {
        System.out.println("SET:" + command);
    }

    @Override
    public void onCommand(String command) {
        System.out.println(command);
    }
}
