package br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.cacher.key.generic;

import java.lang.reflect.Method;

public class ParamsBasedKeyGenerator implements KeyGenerator {

    /**
     * Generate a key based on the specified parameters.
     */
    @Override
    public Object generate(Object target, Method method, Object... params) {
        return generateKey(params);
    }

    /**
     * Generate a key based on the specified parameters.
     */
    public static Object generateKey(Object... params) {
        if (params.length == 0) {
            return SimpleKey.EMPTY;
        }
        if (params.length == 1) {
            Object param = params[0];
            if (param != null && !param.getClass().isArray()) {
                return param;
            }
        }
        return new SimpleKey(params);
    }

}
