/*
 * Copyright 2002-2015 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.model.support;

import java.io.Serializable;

/**
 * Simple serializable class that serves as a {@code null} replacement
 * for model stores which otherwise do not support {@code null} values.
 *
 * @author Juergen Hoeller
 * @see br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.model.support.AbstractValueAdaptingCache
 * @since 4.2.2
 */
public final class NullValue implements Serializable {

    static final Object INSTANCE = new NullValue();

    private static final long serialVersionUID = 1L;


    private NullValue() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

}
