package br.ufrgs.inf.prosoft.adaptivecaching.monitoring.storage;

import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.RepositoryType;
import br.ufrgs.inf.prosoft.adaptivecaching.exceptions.StorageException;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.metadata.LogTrace;
import com.mongodb.MongoClient;
import com.mongodb.MongoTimeoutException;
import com.mongodb.client.MongoDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class RepositoryFactory {

    static Logger logger = LoggerFactory.getLogger(RepositoryFactory.class);

    public static Repository getRepository(Properties properties, RepositoryType repositoryType) throws IOException {

        switch (repositoryType) {
            case MONGODB:
                try {
                    MongoClient mongo = new MongoClient(properties.getProperty("adaptivecaching.monitoring.db.address"), Integer.parseInt(properties.getProperty("adaptivecaching.monitoring.db.port")));
                    MongoDatabase database = mongo.getDatabase(properties.getProperty("adaptivecaching.monitoring.db.scheme"));
                    Repository repository = new MongoRepository<>(database.getCollection(properties.getProperty("adaptivecaching.monitoring.db.name")), LogTrace.class);
                    logger.debug("Repository created to MongoDB: " + repository.toString());
                    return repository;
                } catch (MongoTimeoutException e) {
                    throw new StorageException("Cannot connect with MongoDB with the defined properties.", e);
                }
            case REDIS:
                //TODO decouple it from redis and get of properties
                logger.debug("Repository is configured to Redis.");
                return new RedisRepository<LogTrace>();
            case TEXTFILE:
                //TODO decouple it from redis and get of properties
                AsyncFileWriter as = new AsyncFileWriter(new File("traces.txt"));
                as.open();
                logger.debug("Repository is configured to save logs in textfile.");
                return as;
            case MEMORY:
                //TODO decouple it from redis and get of properties
                //TODO log a warning because memory can take too much from the application...
                logger.warn("Repository is configured to save logs in Memory, which is not recommended because it can take too much from the application.");
                return new MemoryRepository<LogTrace>();
            case CONSOLE:
                //TODO decouple it from redis and get of properties
                logger.warn("Repository is configured to just show logs in console. Nothing will be recorded");
                return new ConsoleRepository<LogTrace>();
            default:
                throw new StorageException("The specified repository type [" + repositoryType +"] does not have an available implementation.");
        }
    }
}
