package br.ufrgs.inf.prosoft.adaptivecaching.analysis.decision.flowchart;

import br.ufrgs.inf.prosoft.adaptivecaching.analysis.Analyzer;
import br.ufrgs.inf.prosoft.adaptivecaching.analysis.decision.flowchart.model.MethodEntry;
import br.ufrgs.inf.prosoft.adaptivecaching.analysis.decision.flowchart.stats.CacheabilityMetrics;
import br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.extensions.ehcache.EhCacheCache;
import br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.extensions.ehcache.EhCacheCacheManager;
import br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.model.Cache;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.AdaptiveCaching;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.CacheProviderType;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.Modelling;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.RepositoryType;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.TriggerType;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.metadata.LogTrace;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.cache.CacheMonitor;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.cache.vendors.ehcache.EhCacheMonitor;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.storage.MongoRepository;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.storage.Repository;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.hash.Hashing;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoDatabase;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.PersistenceConfiguration;
import net.sf.ehcache.management.ManagementService;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.junit.Assert;
import org.junit.Test;

import javax.management.MBeanServer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.util.LinkedList;

public class Learner {

//    private void printToFile(CacheabilityMetrics stats) {
//        PrintWriter pw = null;
//        try {
//            pw = new PrintWriter(new File("test.csv"));
//            pw.write("numberOfSameOccurrences,numberOfDifferentReturnOccurrences,totalOccurrences,sameOccurrencesAverageExecutionTime,sameOccurrencesTotalExecutionTime,hitRatio,missRatio");
//            for (MethodInfo mi : stats.getMethodsInfoMap().keySet()) {
//                pw.write(stats.getMethodsInfoMap().get(mi).toString() + '\n');
//            }
//            pw.close();
//        } catch (FileNotFoundException e) {
//            e.printStackTrace();
//        }
//    }

    @Test
    public void hashTest(){
        Kryo kryo = new Kryo();

        LinkedList list = new LinkedList();
        list.add("thishitis");
        list.add("bananas");
        Output output = new Output(new ByteArrayOutputStream());
        kryo.writeObject(output, list);

        LinkedList list1 = new LinkedList();
        list1.add("thishitis");
        list1.add("bananas");
        Output output2 = new Output(new ByteArrayOutputStream());
        kryo.writeObject(output2, list1);

        System.out.println(output.hashCode());
        System.out.println(output2.hashCode());

        Assert.assertEquals(Hashing.md5().hashBytes(output.toBytes()).toString(),
                Hashing.md5().hashBytes(output2.toBytes()).toString());
    }

    @Test
    public void sampleSize() {
        Assert.assertEquals(CacheabilityMetrics.sampleSize(593816, 2.575, 0.03), 248);
    }

    @Test
    public void testCacheableMethods() throws IOException {

        MongoClient mongo = new MongoClient("localhost", 27017);
        MongoDatabase database = mongo.getDatabase("cachemonitoring");
        Repository repositoryTarget = new MongoRepository<MethodEntry>(database.getCollection("petclinic-cacheable"), MethodEntry.class);
        Repository repository = new MongoRepository<LogTrace>(database.getCollection("petclinic"), LogTrace.class);

        CacheManager cm = CacheManager.newInstance();
        //Create a Cache specifying its configuration.
        net.sf.ehcache.Cache adaptiveCache = new net.sf.ehcache.Cache(
                new CacheConfiguration("adaptivecaching", 100)
                        .memoryStoreEvictionPolicy(MemoryStoreEvictionPolicy.LRU)
                        .eternal(false)
                        .overflowToOffHeap(false)
                        .timeToLiveSeconds(60)
                        .timeToIdleSeconds(30)
                        .persistence(new PersistenceConfiguration().strategy(PersistenceConfiguration.Strategy.NONE)));
        cm.addCache(adaptiveCache);

        EhCacheCacheManager cacheManager = new EhCacheCacheManager(cm);
        Cache cache = cacheManager.getCache("adaptivecaching");

        CacheMonitor cacheMonitor = new EhCacheMonitor((EhCacheCache) cache);
        System.out.println(cacheMonitor.getCacheInfo());

//        GuavaCacheManager cacheManager = new GuavaCacheManager();
//        GuavaCache cache = (GuavaCache) cacheManager.getCache("adaptivecaching");
//        CacheMonitor cacheMonitor = new GuavaMonitor(cache);
//        System.out.println(cacheMonitor.getCacheInfo());

        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        ManagementService.registerMBeans(cm, mBeanServer, false, false, false, true);


        AdaptiveCaching adaptiveCaching = new AdaptiveCaching() {
            @Override
            public boolean equals(Object obj) {
                return false;
            }

            @Override
            public int hashCode() {
                return 0;
            }

            @Override
            public String toString() {
                return null;
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return null;
            }

            @Override
            public boolean enabled() {
                return true;
            }

            @Override
            public RepositoryType logRepository() {
                return RepositoryType.MONGODB;
            }

            @Override
            public CacheProviderType cacheProvider() {
                return CacheProviderType.GUAVA;
            }

            @Override
            public Modelling modelling() {
                return Modelling.ACCUMULATION;
            }

            @Override
            public long expiryInterval() {
                return 0;
            }

            @Override
            public long firstExpiry() {
                return 0;
            }

            @Override
            public long analysisInterval() {
                return 0;
            }

            @Override
            public long firstAnalysis() {
                return 0;
            }

            @Override
            public TriggerType triggerType() {
                return TriggerType.TIME;
            }

            @Override
            public long triggerTime() {
                return 5;
            }

            @Override
            public boolean analyzerEnabled() {
                return true;
            }

            @Override
            public boolean disableMonitoringAfterAnalysis() {
                return false;
            }

            @Override
            public boolean traceAsync() {
                return true;
            }

            @Override
            public boolean clearMonitoringDataOnStart() {
                return false;
            }

            @Override
            public boolean enableBlacklist() {
                return false;
            }

            @Override
            public boolean tracerEnabled() {
                return true;
            }

            @Override
            public boolean analyzeOnce() {
                return false;
            }
        };
        Analyzer analyzer = new Analyzer(repository, repositoryTarget, cacheMonitor.getCacheInfo(), adaptiveCaching);
        analyzer.run();
//        System.out.println(TracerAspect.cacheableMethods.size());
    }
}
