package br.ufrgs.inf.prosoft.tests.adaptivecaching;

import br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.cacher.extensions.provided.Tunnel;
import br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.cacher.key.Key;
import br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.extensions.ehcache.EhCacheCacheManager;
import br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.model.Cache;
import br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.model.support.SimpleValueWrapper;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.PersistenceConfiguration;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.hamcrest.CoreMatchers;
import org.hamcrest.MatcherAssert;
import org.mockito.Mockito;

import java.lang.reflect.Method;

/**
 * Tests for {@link MethodCacher}.
 *
 * @author Nesterov Nikolay (nikolaynesterov@gmail.com)
 * @version $Id$
 * @since 1.0
 */
public final class MethodCacherTest {

//    @Test
    public void testKeysCaching() throws Throwable {
        CacheManager cm = CacheManager.newInstance();
        //Create a Cache specifying its configuration.
        net.sf.ehcache.Cache adaptiveCache = new net.sf.ehcache.Cache(
                new CacheConfiguration("adaptivecaching", 100)
                        .memoryStoreEvictionPolicy(MemoryStoreEvictionPolicy.LRU)
                        .eternal(false)
                        .overflowToOffHeap(false)
                        .timeToLiveSeconds(60)
                        .timeToIdleSeconds(30)
                        .persistence(new PersistenceConfiguration().strategy(PersistenceConfiguration.Strategy.NONE)));
        cm.addCache(adaptiveCache);

        EhCacheCacheManager cacheManager = new EhCacheCacheManager(cm);
        Cache cache = cacheManager.getCache("adaptivecaching");


        final ProceedingJoinPoint point = Mockito.mock(
                ProceedingJoinPoint.class
        );
        Mockito.when(point.getArgs()).thenReturn(new Object[]{});
        Mockito.when(point.getSignature()).thenReturn(new MethodSignature() {
            @Override
            public Class getReturnType() {
                return null;
            }

            @Override
            public Method getMethod() {
                return null;
            }

            @Override
            public Class[] getParameterTypes() {
                return new Class[0];
            }

            @Override
            public String[] getParameterNames() {
                return new String[0];
            }

            @Override
            public Class[] getExceptionTypes() {
                return new Class[0];
            }

            @Override
            public String toShortString() {
                return null;
            }

            @Override
            public String toLongString() {
                return null;
            }

            @Override
            public String getName() {
                return null;
            }

            @Override
            public int getModifiers() {
                return 0;
            }

            @Override
            public Class getDeclaringType() {
                return null;
            }

            @Override
            public String getDeclaringTypeName() {
                return null;
            }
        });

        MethodSignature o = Mockito.mock(MethodSignature.class);
        Mockito.when(o.getMethod()).thenReturn(CacheableTest.Foo.class.getMethod("get"));

        Key k = Mockito.mock(Key.class);
        Mockito.when(k.hashCode()).thenReturn(1);

        final Key key = new Key(point);

        final CacheableTest.Foo foo = new CacheableTest.Foo(1L);
        final String first = foo.get().toString();
        cache.put(key, new SimpleValueWrapper(foo));

        MatcherAssert.assertThat(first, CoreMatchers.equalTo(cache.get(key)));
    }

    /**
     * MethodCacher can support garbage collecting.
     *
     * @throws Throwable If something goes wrong
     * @checkstyle IllegalThrowsCheck (3 lines)
     */
//    @Test
    public void supportsGarbageCollecting() throws Throwable {
        final ProceedingJoinPoint point = Mockito.mock(
                ProceedingJoinPoint.class
        );
        Mockito.when(point.proceed()).thenReturn(new Object());
        final Key key = Mockito.mock(
                Key.class
        );
        final Tunnel tunnel = new Tunnel(
                point, key, false
        );
        final MethodSignature methodSignature = Mockito.mock(
                MethodSignature.class
        );
        final Method method = Buzz.class.getMethod("get");
        Mockito.when(methodSignature.getMethod()).thenReturn(method);
        Mockito.when(point.getSignature()).thenReturn(methodSignature);
        tunnel.through();
        MatcherAssert.assertThat(tunnel.expired(), CoreMatchers.equalTo(false));
        tunnel.cached().clear();
        MatcherAssert.assertThat(tunnel.expired(), CoreMatchers.equalTo(true));
    }

    /**
     * Test class for tests above.
     */
    private static class Buzz {
        /**
         * Return some object.
         *
         * @return Some object.
         */
//        @Cacheable(forever = true)
        public Object get() {
            return new Object();
        }
    }
}
