package com.salesmanager.web;

import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.AdaptiveCaching;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.ComponentScan;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.CacheProviderType;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.Modelling;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.RepositoryType;

@AdaptiveCaching(cacheProvider = CacheProviderType.EHCACHE, logRepository = RepositoryType.MEMORY,
        modelling = Modelling.FULLEXPLORATION, analyzerEnabled = true, enabled = true, disableMonitoringAfterAnalysis = true, traceAsync = false, tracerEnabled = true, analyzeOnce = true)
@ComponentScan(allowed = "com.salesmanager", denied = {"model", "com.salesmanager.web.entity", "com.salesmanager.web.populator",
        "com.salesmanager.web.utils.BreadcrumbsUtils.buildProductBreadcrumb",
        "com.salesmanager.web.utils.BreadcrumbsUtils.buildCategoryBreadcrumb",
        "com.salesmanager.web.filter.AdminFilter"})
public class Configuration {
}
