package br.ufrgs.inf.prosoft.adaptivecaching.sampling.metrics;

import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.util.FastMath;

import java.util.ArrayList;
import java.util.List;

public class LightweightMetrics {

    private long occurrences;
    private List<Long> times;
    private List<Long> memories;
    private List<Long> threadNumber;
    private long throwns;
    private List<Long> startTimes;

    //not able to get CPU usage

    public LightweightMetrics(){
        startTimes = new ArrayList<>();
        times = new ArrayList<>();
        memories = new ArrayList<>();
        threadNumber = new ArrayList<>();
    }

    public void addTime(long startTime, long time){
        startTimes.add(startTime);
        times.add(time);
    }

    public void addThreadNumber(long threads){
        threadNumber.add(threads);
    }

    public void addMemoryConsumption(long memory){
        memories.add(memory);
    }

    public void incThrown() {
        throwns++;
    }

    public void incOccurrence() {
        occurrences++;
    }

    public List<Long> interIntervals(){
        List<Long> intervalTimes = new ArrayList<>();
        long lastTime = startTimes.get(0);
        for(Long l : startTimes){
            intervalTimes.add(l - lastTime);
            lastTime = l;
        }
        return intervalTimes;
    }

    public long getOccurrences() {
        return occurrences;
    }

    @Override
    public String toString() {
        return "{" +
                "occurrences=" + occurrences +
                '}';
    }
}
