package br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation;

import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.CacheProviderType;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.Modelling;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.RepositoryType;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.TriggerType;

import java.lang.annotation.*;

/**
 * The interface Adaptive caching.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Documented
public @interface AdaptiveCaching {

    /**
     * Cache provider cache provider type.
     *
     * @return the cache provider type
     */
    CacheProviderType cacheProvider() default CacheProviderType.GUAVA;

    /**
     * Modelling modelling.
     *
     * @return the modelling
     */
    Modelling modelling() default Modelling.ACCUMULATION;

    /**
     * Expiry interval long.
     *
     * @return the long
     */
    long expiryInterval() default 300000; //5 minutes

    /**
     * First expiry long.
     *
     * @return the long
     */
    @Deprecated long firstExpiry() default 300000; //5 minutes

    /**
     * Analysis interval long.
     *
     * @return the long
     */
//todo when analysis based on trigger do not make sense to have this, its similar to trigger by time
    @Deprecated long analysisInterval() default 1200000; //20 minutes

    /**
     * First analysis long.
     *
     * @return the long
     */
    @Deprecated long firstAnalysis() default 240000; //4 minutes
//    @Deprecated long firstAnalysis() default 60000; //1 minutes

    /**
     * Trigger type trigger type.
     *
     * @return the trigger type
     */
    TriggerType triggerType() default TriggerType.TIME; //if were not by time, load the class that implements the interface @Trigger

    /**
     * Trigger time long.
     *
     * @return the long
     */
    long triggerTime() default 300000; //5 minutes

    /**
     * Analyze once boolean.
     *
     * @return the boolean
     */
//enables the analyzer to be executed just once
    boolean analyzeOnce() default false;

    /**
     * Disable monitoring after analysis boolean.
     *
     * @return the boolean
     */
//disable the monitoring after the first analyses
    boolean disableMonitoringAfterAnalysis() default false;

    /**
     * Trace async boolean.
     *
     * @return the boolean
     * @deprecated async use may consume too much memory and cause stack overflow
     */
    @Deprecated boolean traceAsync() default true;
}
