package br.ufrgs.inf.prosoft.tigrisframework.annotations;

import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.RepositoryType;

import java.lang.annotation.*;

/**
 * The interface Tigris configuration.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Documented
public @interface TigrisConfiguration {

    /**
     * Static metric file string.
     *
     * @return the string
     */
    String staticMetricFile();


    /**
     * Log repository repository type.
     *
     * @return the repository type
     */
    RepositoryType logRepository() default RepositoryType.MONGODB;

    /**
     * Clear monitoring data on start boolean.
     *
     * @return the boolean
     */
    boolean clearMonitoringDataOnStart() default false;

    /**
     * Criteria in form of SET operations over the criteria.
     * <p>
     * Operations allowed: union (U), intersection (I), difference (D), complement (C)
     * Verbs: frequent, expensive, changeable, errorprone, globalimpact
     * Additional: more, less
     * <p>
     * Examples:
     * more frequent U more expensive C less changeable
     * less frequent C less expensive
     *
     * @return the string
     */
    String criteria();

}
