package br.ufrgs.inf.prosoft.tigrisframework.metrics;


import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * The type Static metrics.
 */
public class StaticMetrics {

    private Map<String, StaticMetric> metrics;

    /**
     * Instantiates a new Static metrics.
     *
     * @param filename the filename
     * @throws IOException the io exception
     */
    public StaticMetrics(String filename) throws IOException {
        loadMetrics(filename);
    }

    /**
     * Get metrics static metric.
     *
     * @param method the method
     * @return the static metric
     */
    public StaticMetric getMetrics(String method){
        return metrics.get(method);
    }

    /**
     * Load metrics.
     *
     * @param filename the filename
     * @throws IOException the io exception
     */
    public void loadMetrics(String filename) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(filename));
        String line = null;
        metrics = new HashMap<>();

        while ((line = br.readLine()) != null) {
            if (line.contains("Kind")) continue;
            String str[] = line.split(",");
            metrics.put(str[1], new StaticMetric(Long.valueOf(str[2]), Long.valueOf(str[3]), Long.valueOf(str[4])));
        }
    }

    /**
     * Gets all metrics.
     *
     * @return the all metrics
     */
    public Map<String, StaticMetric> getAllMetrics() {
        return metrics;
    }

    /**
     * The type Static metric.
     */
    public class StaticMetric {
        /**
         * The Count output.
         */
        public long countOutput;
        /**
         * The Cyclomatic.
         */
        public long cyclomatic;
        /**
         * The Max nesting.
         */
        public long maxNesting;

        /**
         * Instantiates a new Static metric.
         *
         * @param countOutput the count output
         * @param cyclomatic  the cyclomatic
         * @param maxNesting  the max nesting
         */
        public StaticMetric(long countOutput, long cyclomatic, long maxNesting) {
            this.countOutput = countOutput;
            this.cyclomatic = cyclomatic;
            this.maxNesting = maxNesting;
        }

        @Override
        public String toString() {
            return "StaticMetric{" +
                    "countOutput=" + countOutput +
                    ", cyclomatic=" + cyclomatic +
                    ", maxNesting=" + maxNesting +
                    '}';
        }
    }
}
