package br.ufrgs.inf.prosoft.tigrisframework.monitoring.metadata;

/**
 * The type Log trace.
 */
public class LogTrace{

    private MethodInfo methodInfo;
    private long startTime;
    private long endTime;
    private String userId;

    /**
     * Gets method info.
     *
     * @return the method info
     */
    public MethodInfo getMethodInfo() {
        return this.methodInfo;
    }

    /**
     * Sets method info.
     *
     * @param methodInfo the method info
     */
    public void setMethodInfo(MethodInfo methodInfo) {
        this.methodInfo = methodInfo;
    }

    /**
     * Total time long.
     *
     * @return the long
     */
    public long totalTime() {
        return endTime - startTime;
    }

    /**
     * Gets start time.
     *
     * @return the start time
     */
    public long getStartTime() {
        return this.startTime;
    }

    /**
     * Sets start time.
     *
     * @param startTime the start time
     */
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    /**
     * Gets end time.
     *
     * @return the end time
     */
    public long getEndTime() {
        return this.endTime;
    }

    /**
     * Sets end time.
     *
     * @param endTime the end time
     */
    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    /**
     * Gets user id.
     *
     * @return the user id
     */
    public String getUserId() {
        return userId;
    }

    /**
     * Sets user id.
     *
     * @param userId the user id
     */
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof LogTrace)) return false;

        LogTrace logTrace = (LogTrace) o;

        if (endTime != logTrace.endTime) return false;
        if (startTime != logTrace.startTime) return false;
        if (methodInfo != null ? !methodInfo.equals(logTrace.methodInfo) : logTrace.methodInfo != null) return false;
        if (userId != null ? !userId.equals(logTrace.userId) : logTrace.userId != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = methodInfo != null ? methodInfo.hashCode() : 0;
        result = 31 * result + (int) (startTime ^ (startTime >>> 32));
        result = 31 * result + (int) (endTime ^ (endTime >>> 32));
        result = 31 * result + (userId != null ? userId.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "LogTrace{" +
                "methodInfo=" + methodInfo +
                ", startTime=" + startTime +
                ", endTime=" + endTime +
                ", userId='" + userId + '\'' +
                '}';
    }
}
