package br.ufrgs.inf.prosoft.tigrisframework.monitoring.storage;

import br.ufrgs.inf.prosoft.adaptivecaching.exceptions.StorageException;

import java.util.List;

/**
 * The interface Repository.
 *
 * @param <T> the type parameter
 */
public interface Repository<T> {

    /**
     * Save.
     *
     * @param t the t
     * @throws StorageException the storage exception
     */
    void save(T t) throws StorageException;

    /**
     * Find all list.
     *
     * @return the list
     */
    List<T> findAll();

    /**
     * Remove all.
     */
    void removeAll();

    /**
     * Save all.
     *
     * @param toSave the to save
     */
    void saveAll(List<T> toSave);
}
