package br.ufrgs.inf.prosoft.utils;

import br.ufrgs.inf.prosoft.adaptivecaching.exceptions.ConfigurationException;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

import java.util.Set;

public final class ConfigurationUtils {

    public static Class<?> getAvailableConfigurationClass(Class annotation) {
        Reflections reflections = new Reflections(
                new ConfigurationBuilder()
                        .setUrls(ClasspathHelper.forClassLoader())
                        .setScanners(new SubTypesScanner(false), new ResourcesScanner(), new TypeAnnotationsScanner()));

        Set<Class<?>> configurations =
                reflections.getTypesAnnotatedWith(annotation);
        if (configurations.isEmpty())
            throw new ConfigurationException(annotation.getName() + " not found.");
        if (configurations.size() > 1)
            throw new ConfigurationException(annotation.getName() + " has too many definitions.");
        return configurations.iterator().next();
    }

}
