package br.ufrgs.inf.prosoft.adaptivecaching.sampling.metrics;

import br.ufrgs.inf.prosoft.adaptivecaching.analysis.decision.flowchart.model.MethodEntry;
import br.ufrgs.inf.prosoft.adaptivecaching.analysis.decision.flowchart.stats.CacheabilityMetrics;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.aspects.TracerAspect;
import br.ufrgs.inf.prosoft.adaptivecaching.sampling.statistics.StatisticalTest;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LightweightAnalyzer implements Runnable {

    static Logger logger = LoggerFactory.getLogger(LightweightAnalyzer.class);

    public static Set<String> allowedFineGrained = new HashSet<>();

    public static void analyze() {

        logger.info("Analyzing {} lightweight methods for relevance...", TracerAspect.metrics.size());

        DescriptiveStatistics frequencies = new DescriptiveStatistics();
        DescriptiveStatistics changeabilities = new DescriptiveStatistics();
        DescriptiveStatistics errorprones = new DescriptiveStatistics();
        DescriptiveStatistics latencies = new DescriptiveStatistics();
        DescriptiveStatistics maintainabilities = new DescriptiveStatistics();
        DescriptiveStatistics userBehaviors = new DescriptiveStatistics();
        DescriptiveStatistics concurrencies = new DescriptiveStatistics();
        DescriptiveStatistics expensiveness = new DescriptiveStatistics();
        DescriptiveStatistics globalimpacts = new DescriptiveStatistics();
        for (String method : TracerAspect.metrics.keySet()) {
            LightweightMetrics sc = TracerAspect.metrics.get(method);
            frequencies.addValue(sc.getFrequency());
            changeabilities.addValue(sc.getChangeability());
            errorprones.addValue(sc.getErrorprone());
            latencies.addValue(sc.getLatency());
            maintainabilities.addValue(sc.getMaintainability());
            userBehaviors.addValue(sc.getUserBehavior());
            concurrencies.addValue(sc.getConcurrency());
            expensiveness.addValue(sc.getExpensiveness());
            globalimpacts.addValue(sc.getGlobalImpact());
        }

        System.out.println("---------------------------");
        System.out.println("Metric: frequency; Distribution: " +
                ((StatisticalTest.isNormalDistribution(frequencies.getValues(), 0.05)) ? "normal" : "not_normal"));
        System.out.println("Metric: maintainability; Distribution: " +
                ((StatisticalTest.isNormalDistribution(maintainabilities.getValues(), 0.05)) ? "normal" : "not_normal"));
        System.out.println("Metric: changeability; Distribution: " +
                ((StatisticalTest.isNormalDistribution(changeabilities.getValues(), 0.05)) ? "normal" : "not_normal"));
        System.out.println("Metric: userBehavior; Distribution: " +
                ((StatisticalTest.isNormalDistribution(userBehaviors.getValues(), 0.05)) ? "normal" : "not_normal"));
        System.out.println("Metric: concurrency; Distribution: " +
                ((StatisticalTest.isNormalDistribution(concurrencies.getValues(), 0.05)) ? "normal" : "not_normal"));
        System.out.println("Metric: errorprone; Distribution: " +
                ((StatisticalTest.isNormalDistribution(errorprones.getValues(), 0.05)) ? "normal" : "not_normal"));
        System.out.println("Metric: expensiveness; Distribution: " +
                ((StatisticalTest.isNormalDistribution(expensiveness.getValues(), 0.05)) ? "normal" : "not_normal"));
        System.out.println("Metric: globalimpact; Distribution: " +
                ((StatisticalTest.isNormalDistribution(globalimpacts.getValues(), 0.05)) ? "normal" : "not_normal"));
        System.out.println("Metric: latency; Distribution: " +
                ((StatisticalTest.isNormalDistribution(latencies.getValues(), 0.05)) ? "normal" : "not_normal"));

        //cleaning selected methods
        allowedFineGrained = new HashSet<>();

        //TODO process SET operations dynamically
//        LightweightMetricAspect.criteriaDSL

        //less changeable C more frequent C (more user_behavior U (less user_behavior C more expensive))
        for(String method : TracerAspect.metrics.keySet()) {
            LightweightMetrics sc = TracerAspect.metrics.get(method);

//           if ((DataFiltering.isGroup("less", changeabilities, sc.getChangeability())
//                    || DataFiltering.isGroup("normal", changeabilities, sc.getChangeability()))
//                    && (DataFiltering.isGroup("more", frequencies, sc.getFrequency())
//                    || DataFiltering.isGroup("normal", frequencies, sc.getFrequency()))
//                    && ((DataFiltering.isGroup("more", userBehaviors, sc.getUserBehavior())
//                    || DataFiltering.isGroup("normal", userBehaviors, sc.getUserBehavior()))
//                    || ((DataFiltering.isGroup("less", userBehaviors, sc.getUserBehavior())
//                       || DataFiltering.isGroup("normal", userBehaviors, sc.getUserBehavior()))
//                    && (DataFiltering.isGroup("more", expensiveness, sc.getExpensiveness())
//                        || DataFiltering.isGroup("more", expensiveness, sc.getExpensiveness())))))

            //less changeable C more frequent C (more user_behavior U (less user_behavior C more expensive))
            if (DataFiltering.isGroup("less", changeabilities, sc.getChangeability())
                && DataFiltering.isGroup("more", frequencies, sc.getFrequency())
                && (DataFiltering.isGroup("more", userBehaviors, sc.getUserBehavior())
                    || (DataFiltering.isGroup("less", userBehaviors, sc.getUserBehavior())
                        && DataFiltering.isGroup("more", expensiveness, sc.getExpensiveness()))))

//            if (DataFiltering.isGroup("least", changeabilities, sc.getChangeability())
//                && DataFiltering.isGroup("most", frequencies, sc.getFrequency())
//                && (DataFiltering.isGroup("most", userBehaviors, sc.getUserBehavior())
//                    || (DataFiltering.isGroup("least", userBehaviors, sc.getUserBehavior())
//                        && DataFiltering.isGroup("most", expensiveness, sc.getExpensiveness()))))

//            if (DataFiltering.isGroup("less", changeabilities, sc.getChangeability())
//                    && DataFiltering.isGroup("most", frequencies, sc.getFrequency())
//                    && DataFiltering.isGroup("most", expensiveness, sc.getExpensiveness()))

                allowedFineGrained.add(sc.getLongName());
        }
        logger.info("Selected methods for fine-grained: {}", allowedFineGrained);

//        TracerAspect.enabled = true;
        TracerAspect.analyzerEnabled = true;
//        LightweightMetricAspect.enabled = true;

        //TODO remove: print all unique methods and metrics to csv file
        logger.info("Printing lightweigth metrics...");
        try {
            final PrintWriter pw = new PrintWriter(new File("lightweightanalysis.csv"));
            pw.write("method,frequency,maintainability,changeability,userBehavior,concurrency,errorprone,expensiveness,globalimpact,latency,vfrequency,vmaintainability,vchangeability,vuserBehavior,vconcurrency,verrorprone,vexpensiveness,vglobalimpact,vlatency\n");
            for(String name : TracerAspect.metrics.keySet()){
                pw.write(TracerAspect.metrics.get(name).getName() + "," +
                    DataFiltering.getGroup(frequencies, TracerAspect.metrics.get(name).getFrequency()) +
                    "," + DataFiltering.getGroup(maintainabilities, TracerAspect.metrics.get(name).getMaintainability()) +
                    "," + DataFiltering.getGroup(changeabilities, TracerAspect.metrics.get(name).getChangeability()) +
                    "," + DataFiltering.getGroup(userBehaviors, TracerAspect.metrics.get(name).getUserBehavior()) +
                    "," + DataFiltering.getGroup(concurrencies, TracerAspect.metrics.get(name).getConcurrency()) +
                    "," + DataFiltering.getGroup(errorprones, TracerAspect.metrics.get(name).getErrorprone()) +
                    "," + DataFiltering.getGroup(expensiveness, TracerAspect.metrics.get(name).getExpensiveness()) +
                    "," + DataFiltering.getGroup(globalimpacts, TracerAspect.metrics.get(name).getGlobalImpact()) +
                    "," + DataFiltering.getGroup(latencies, TracerAspect.metrics.get(name).getLatency()) +
                    "," +
                        DataFiltering.allMetricsToString(TracerAspect.metrics.get(name)) + '\n');
            }
            pw.close();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        if (!TracerAspect.lightweightTracerEnabled) {
            logger.info("Lightweight monitoring disabled...");
            return;
        }

        analyze();
    }
}
