package br.ufrgs.inf.prosoft.adaptivecaching.cache;

import br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.extensions.ehcache.EhCacheCache;
import br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.extensions.guava.GuavaCache;
import br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.model.Cache;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.types.CacheProviderType;
import br.ufrgs.inf.prosoft.adaptivecaching.exceptions.CacheProviderException;
import br.ufrgs.inf.prosoft.adaptivecaching.cache.vendors.ehcache.EhCacheMonitor;
import br.ufrgs.inf.prosoft.adaptivecaching.cache.vendors.guava.GuavaMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * The type Cache monitor factory.
 */
public class CacheMonitorFactory {

    /**
     * The Logger.
     */
    static Logger logger = LoggerFactory.getLogger(CacheMonitorFactory.class);

    /**
     * Gets cache monitor.
     *
     * @param cache             the cache
     * @param cacheProviderType the cache provider type
     * @return the cache monitor
     */
    public static CacheMonitor getCacheMonitor(Cache cache, CacheProviderType cacheProviderType) {
        switch (cacheProviderType) {
            case GUAVA:
                return new GuavaMonitor((GuavaCache) cache);
//            case MEMCACHED:
//                break;
//            case REDIS:
            //redis cache manager
//        JedisConnectionFactory cf = new JedisConnectionFactory();
//        cf.setHostName("127.0.0.1");
//        cf.setPort(6379);
//        RedisTemplate<String, String> redisTemplate = new RedisTemplate<String, String>();
//        redisTemplate.setConnectionFactory(cf);
//        RedisCacheManager redisCacheManager = new RedisCacheManager(redisTemplate);
//        redisCacheManager.setDefaultExpiration(300);
//        this.cacheManager = redisCacheManager;
//        this.cache = redisCacheManager.getCache("test");
//                break;
//            case CAFFEINE:
//                break;
            case EHCACHE:
                return new EhCacheMonitor((EhCacheCache) cache);
            default:
                throw new CacheProviderException("The specified cache monitor [" + cacheProviderType + "] does not have an available implementation.");
        }
    }
}
