package org.springframework.samples.petclinic;

import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.AdaptiveCaching;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.types.CacheProviderType;
import br.ufrgs.inf.prosoft.tigris.configuration.annotation.ComponentScan;
import br.ufrgs.inf.prosoft.tigris.configuration.annotation.Metrics;
import br.ufrgs.inf.prosoft.tigris.configuration.annotation.TigrisConfiguration;
import br.ufrgs.inf.prosoft.tigris.configuration.annotation.TigrisCriteria;
import br.ufrgs.inf.prosoft.tigris.configuration.types.Modelling;
import br.ufrgs.inf.prosoft.tigris.configuration.types.RepositoryType;
import br.ufrgs.inf.prosoft.tigris.sampling.GranularityType;

@TigrisConfiguration(
    logRepository = RepositoryType.MEMORY,
    staticMetricFile = "petclinic.csv",
    samplingPercentage = 0.5)
@TigrisCriteria(
    criteria = "more frequent '∪' more expensive",
    granularity = GranularityType.METHOD,
    frequencyMetric = Metrics.INVOCATION_FREQUENCY,
    expensivenessMetric = Metrics.EXECUTION_TIME,
    changeabilityMetric = Metrics.COMPUTATION_PATTERN
)
@AdaptiveCaching(cacheProvider = CacheProviderType.EHCACHE,
    modelling = Modelling.FULLEXPLORATION, disableMonitoringAfterAnalysis = false,
    analyzeOnce = true, expiryInterval = 60)
@ComponentScan(allowed = "org.springframework.samples.petclinic.*", denied = "org.springframework.samples.petclinic.model.*")
public class Configuration {
}
