/*******************************************************************************
 *  Copyright (c) 2015 XLAB d.o.o.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  @author XLAB d.o.o.
 *******************************************************************************/
package eu.cloudscale.showcase.db.model.hibernate;

// Generated May 16, 2013 3:07:18 PM by Hibernate Tools 4.0.0

import eu.cloudscale.showcase.db.model.IItem;
import eu.cloudscale.showcase.db.model.IShoppingCart;
import eu.cloudscale.showcase.db.model.IShoppingCartLine;

import javax.persistence.*;

import static javax.persistence.GenerationType.IDENTITY;

/**
 * ShoppingCartLine generated by hbm2java
 */
@Entity
@Table(name = "shopping_cart_line", catalog = "tpcw")
//@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
//TODO Jhonny removed cache
public class ShoppingCartLine implements IShoppingCartLine {
    private Integer sclId;

    private IItem item;

    private Integer sclQty;

    private IShoppingCart shoppingCart;

    public ShoppingCartLine() {
    }

    @ManyToOne(targetEntity = ShoppingCart.class, fetch = FetchType.LAZY)
    @JoinColumn(name = "SCL_SC_ID", nullable = false)
    @Override
    public IShoppingCart getShoppingCart() {
        return shoppingCart;
    }

    @Override
    public void setShoppingCart(IShoppingCart shoppingCart) {
        this.shoppingCart = shoppingCart;
    }


    @Id
    @GeneratedValue(strategy = IDENTITY)
    @Column(name = "SCL_ID", unique = true, nullable = false)
    @Override
    public Integer getSclId() {
        return this.sclId;
    }

    @Override
    public void setSclId(Integer sclScId) {
        this.sclId = sclScId;
    }

    @ManyToOne(targetEntity = Item.class, fetch = FetchType.EAGER)
    @JoinColumn(name = "SCL_I_ID", nullable = false)
    @Override
    public IItem getItem() {
        return this.item;
    }

    @Override
    public void setItem(IItem item) {
        this.item = item;
    }

    @Column(name = "SCL_QTY")
    @Override
    public Integer getSclQty() {
        return this.sclQty;
    }

    @Override
    public void setSclQty(Integer sclQty) {
        this.sclQty = sclQty;
    }
}
