package com.salesmanager.web;


import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.AdaptiveCaching;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.types.CacheProviderType;
import br.ufrgs.inf.prosoft.tigris.configuration.annotation.ComponentScan;
import br.ufrgs.inf.prosoft.tigris.configuration.annotation.Metrics;
import br.ufrgs.inf.prosoft.tigris.configuration.annotation.TigrisConfiguration;
import br.ufrgs.inf.prosoft.tigris.configuration.annotation.TigrisCriteria;
import br.ufrgs.inf.prosoft.tigris.configuration.types.Modelling;
import br.ufrgs.inf.prosoft.tigris.configuration.types.RepositoryType;
import br.ufrgs.inf.prosoft.tigris.sampling.GranularityType;

@TigrisConfiguration(
        logRepository = RepositoryType.MEMORY,
        staticMetricFile = "cloudstore.csv",
        samplingPercentage = 0.5)
@TigrisCriteria(
        criteria = "more frequent '∪' more expensive",
        granularity = GranularityType.METHOD,
        frequencyMetric = Metrics.INVOCATION_FREQUENCY,
        expensivenessMetric = Metrics.EXECUTION_TIME,
        changeabilityMetric = Metrics.COMPUTATION_PATTERN
)
@AdaptiveCaching(cacheProvider = CacheProviderType.EHCACHE,
        modelling = Modelling.FULLEXPLORATION, disableMonitoringAfterAnalysis = false,
        analyzeOnce = true, expiryInterval = 60)
@ComponentScan(allowed = "com.salesmanager.*", denied = "(.*model.*|com.salesmanager.web.entity.*|com.salesmanager.web.populator.*|com.salesmanager.web.utils.BreadcrumbsUtils.buildProductBreadcrumb.*|com.salesmanager.web.utils.BreadcrumbsUtils.buildCategoryBreadcrumb.*|com.salesmanager.web.filter.AdminFilter.*)")
public class Configuration {
}
