package eu.cloudscale.showcase;


import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.AdaptiveCaching;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.types.CacheProviderType;
import br.ufrgs.inf.prosoft.tigris.configuration.annotation.ComponentScan;
import br.ufrgs.inf.prosoft.tigris.configuration.annotation.Metrics;
import br.ufrgs.inf.prosoft.tigris.configuration.annotation.TigrisConfiguration;
import br.ufrgs.inf.prosoft.tigris.configuration.annotation.TigrisCriteria;
import br.ufrgs.inf.prosoft.tigris.configuration.types.Modelling;
import br.ufrgs.inf.prosoft.tigris.configuration.types.RepositoryType;
import br.ufrgs.inf.prosoft.tigris.sampling.GranularityType;

@TigrisConfiguration(
        logRepository = RepositoryType.MEMORY,
        staticMetricFile = "cloudstore.csv",
        samplingPercentage = 0.5)
@TigrisCriteria(
        criteria = "more frequent '∪' more expensive",
        granularity = GranularityType.METHOD,
        frequencyMetric = Metrics.INVOCATION_FREQUENCY,
        expensivenessMetric = Metrics.EXECUTION_TIME,
        changeabilityMetric = Metrics.COMPUTATION_PATTERN
)
@AdaptiveCaching(cacheProvider = CacheProviderType.EHCACHE,
        modelling = Modelling.FULLEXPLORATION, disableMonitoringAfterAnalysis = false,
        analyzeOnce = true, expiryInterval = 60)
@ComponentScan(allowed = "eu.cloudscale.showcase.*", denied = "(eu.cloudscale.showcase.db.model.*|eu.cloudscale.showcase.servlets.*)")
public class Configuration {
}
