package br.ufrgs.inf.prosoft.tigris;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class WorkloadGenerator {

    /**
     * Generates the workload for 20 users
     *
     * The simulation starts with five simultaneous users constantly navigating through the application based on a navigation pattern that falls into a specific distribution (transition table). To stimulate changes in the workload, we created three variations of navigation pattern for each application, and whenever a user is added to the simulation, we randomly decide which of the three workload variations the new user should follow.
     * Then, every second we randomly add or remove a number of users (from 1 to 10) to the simulation until all the users perform the total of 60k requests to the application.
     * Note: We adopted a minimum number of 5 simultaneous users to keep a minimum of concurrency in the workload, and a maximum of 20 to avoid disruptions in the response times due to struggles from the web server.
     *
     * The output of this code is something like:
     *
     * {user1=[3, 3, 3, 3], user11=[0, 2, 2, 0], user2=[3, 3, 3, 3], user10=[0, 1, 1, 0], user20=[0, 0, 0, 0], user15=[0, 0, 0, 0], user14=[0, 0, 0, 0], user13=[0, 0, 2, 0], user12=[0, 1, 1, 0], user9=[0, 3, 3, 3], user7=[0, 2, 2, 2], user8=[0, 3, 3, 3], user5=[1, 1, 1, 1], user6=[0, 2, 2, 2], user3=[2, 2, 2, 2], user4=[2, 2, 2, 2], user19=[0, 0, 0, 0], user18=[0, 0, 0, 0], user17=[0, 0, 0, 0], user16=[0, 0, 0, 0]}
     * where 1,2 and 3 are the ID of the existing workload mixtures
     * 0 means that the user is turned down
     * It can change the workload mixtures when turning up again
     *
     * @param args none of them are used
     */
    public static void main(String[] args){
        Map<String, List<Integer>> users = new HashMap<>();
        for (int i = 1; i <= 20; i++) {
            List<Integer> userNavigation = new ArrayList<>();
            if (i <= 5) {
                userNavigation.add(new Random().nextInt(3) + 1);
                users.put("user" + i, userNavigation);
            } else {
                userNavigation.add(0);
                users.put("user" + i, userNavigation);
            }
        }

        int currentUsers = 5;
        int iterations = 3600;
        for (int i = 0; i < iterations; i++) {
            int factor = (new Random().nextInt(10) + 1) * (new Random().nextInt(2) == 1 ? 1 : -1);
            currentUsers += factor;
            if (currentUsers < 5)
                currentUsers = 5;
            if (currentUsers > 20)
                currentUsers = 20;

            for (int j = 1; j <= 20; j++) {
                List<Integer> userNavigation = users.get("user" + j);
                if (j > currentUsers) { //inactive users
                    userNavigation.add(0);
                } else { //active users
                    if (userNavigation.get(userNavigation.size() - 1) == 0)
                        userNavigation.add(new Random().nextInt(3) + 1);
                    else {
                        userNavigation.add(userNavigation.get(userNavigation.size() - 1));
                    }
                }
            }
        }

        for (int j = 1; j <= 20; j++) {
            System.out.println(users.get("user" + j));
        }
    }

}