/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.memoizeit.adapter;

import br.ufrgs.inf.prosoft.memoizeit.Method;
import br.ufrgs.inf.prosoft.memoizeit.Occurrence;
import br.ufrgs.inf.prosoft.memoizeit.OccurrenceConcrete;
import br.ufrgs.inf.prosoft.memoizeit.OccurrenceReference;
import br.ufrgs.inf.prosoft.memoizeit.Parameter;
import br.ufrgs.inf.prosoft.trace.Trace;
import br.ufrgs.inf.prosoft.trace.TraceReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

/**
 *
 * @author romulo
 */
public class TraceReader extends br.ufrgs.inf.prosoft.trace.reader.TraceReader {

    private static final Logger LOGGER = Logger.getLogger(TraceReader.class.getName());

    public static List<Method> groupByMethods(List<Trace> traces) {
        Map<String, List<Occurrence>> methodNameHasOccurrences = new HashMap<>();
        Set<String> staticMethods = new HashSet<>();
        while (!traces.isEmpty()) {
            Trace trace = traces.remove(0);
            try {
                Occurrence occurrence;
                if (trace instanceof TraceReference) {
                    TraceReference traceReference = (TraceReference) trace;
                    occurrence = new OccurrenceReference(traceReference.getIndex(), trace.getInstance(), trace.getStartTime(), trace.getEndTime());
                } else {
                    List<Parameter> parameters = trace.getParameters().stream()
                            .map(parameter -> new Parameter(parameter.getType(), parameter.getData()))
                            .collect(Collectors.toList());
                    occurrence = new OccurrenceConcrete(trace.getInstance(), trace.getReturn().getData(), parameters, trace.getStartTime(), trace.getEndTime());
                }
                try {
                    methodNameHasOccurrences.get(trace.getName()).add(occurrence);
                } catch (Exception ex) {
                    List<Occurrence> occurrences = new ArrayList<>();
                    occurrences.add(occurrence);
                    methodNameHasOccurrences.put(trace.getName(), occurrences);
                    if (trace.getModifiers().contains("static")) {
                        staticMethods.add(trace.getName());
                    }
                }
            } catch (Exception e) {
                LOGGER.log(Level.INFO, "Trace discarted: {0}", trace);
            }
        }
        List<Method> methods = methodNameHasOccurrences.entrySet().stream().parallel()
                .map(entry -> new Method(entry.getKey(), staticMethods.contains(entry.getKey()), entry.getValue()))
                .collect(Collectors.toList());
        return methods;
    }
}
