/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.approachescomparison.adapter;

import br.ufrgs.inf.prosoft.memoizeit.MemoizeIt;
import br.ufrgs.inf.prosoft.memoizeit.Method;
import br.ufrgs.inf.prosoft.trace.Trace;
import java.util.List;

/**
 *
 * @author romulo
 */
public class Main {

    public static void main(String[] args) {
        String path = null;
        long totalExecutionTime = 0;
        if (args.length < 1) {
            System.err.println("No path provided");
            System.exit(1);
        } else {
            path = args[0];
            if (args.length < 2) {
                System.err.println("No execution time provided");
                try {
                    totalExecutionTime = Long.parseLong(args[1]);
                } catch (NumberFormatException e) {
                    System.err.println("Argument must be a long number");
                    System.exit(1);
                }
            }
        }
        List<Trace> traces = TraceReader.readFile(path);
        MemoizeIt memoizeIt = new MemoizeIt(totalExecutionTime);
        List<Method> methods = TraceReader.groupByMethods(traces);
        memoizeIt.setMethods(methods);
        memoizeIt.removeChangefulMethods();
        methods.forEach(System.out::println);
    }
}
