/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.approachescomparison.adapter;

import br.ufrgs.inf.prosoft.memoizeit.Method;
import br.ufrgs.inf.prosoft.memoizeit.Occurrence;
import br.ufrgs.inf.prosoft.trace.Trace;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author romulo
 */
public class TraceReader {

    public static List<Trace> readFile(String path) {
        List<Trace> traces = new ArrayList<>();
        try {
            List<String> lines = Files.readAllLines(Paths.get(path));
            Gson gson = new Gson();
            for (String line : lines) {
                try {
                    Trace trace = gson.fromJson(line, Trace.class);
                    traces.add(trace);
                } catch (JsonSyntaxException e) {
                    System.err.println("Malformed Trace");
                }
            }
        } catch (IOException ex) {
            Logger.getLogger(TraceReader.class.getName()).log(Level.SEVERE, null, ex);
        }
        return traces;
    }

    public static List<Method> groupByMethods(List<Trace> traces) {
        Map<String, List<Occurrence>> methodNameHasOccurrences = new HashMap<>();
        while (!traces.isEmpty()) {
            Trace trace = traces.remove(0);
            try {
                List<Object> parameters = new ArrayList<>();
                trace.getParameters().forEach((parameter) -> {
                    parameters.add(parameter.getData());
                });
                Occurrence occurrence = new Occurrence(trace.getReturn().getData(), parameters, trace.getStartTime(), trace.getEndTime());
                try {
                    methodNameHasOccurrences.get(trace.getName()).add(occurrence);
                } catch (Exception ex) {
                    List<Occurrence> occurrences = new ArrayList<>();
                    occurrences.add(occurrence);
                    methodNameHasOccurrences.put(trace.getName(), occurrences);
                }
            } catch (Exception e) {
                System.err.println("Trace discarted: " + trace);
            }
        }
        List<Method> methods = new ArrayList<>();
        methodNameHasOccurrences.entrySet().forEach((entry) -> {
            methods.add(new Method(entry.getKey(), entry.getValue()));
        });
        return methods;
    }
}
