/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.memoizeit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 *
 * @author romulo
 */
public class Method {

    private final String name;
    private final List<Occurrence> occurrences;
    private Map<String, List<Occurrence>> groupByParameter;
    private Boolean fullyExplored;

    public Method(String name, List<Occurrence> occurrences) {
        this.name = name;
        this.occurrences = occurrences;
        this.fullyExplored = false;
    }

    public int getOccurrencesSize() {
        return this.occurrences.size();
    }

    public int getDistinctOccurrencesSize() {
        return this.groupByParameter.size();
    }

    public long getTotalExecutionTime() {
        long averageExecutionTime = 0;
        for (Occurrence occurrence : this.occurrences) {
            averageExecutionTime += occurrence.getExecutionTime();
        }
        return averageExecutionTime;
    }

    public long getAverageExecutionTime() {
        return getTotalExecutionTime() / this.occurrences.size();
    }

    protected boolean wasFullyExplored() {
        return this.fullyExplored;
    }

    protected void groupByParameter(int depth) {
        this.groupByParameter = new HashMap<>();
        this.occurrences.forEach((occurrence) -> {
            Occurrence truncated = occurrence.getView(depth);
            this.fullyExplored = truncated == occurrence;
            occurrence = truncated;
            String parameters = occurrence.getParameters().toString();
            try {
                this.groupByParameter.get(parameters).add(occurrence);
            } catch (Exception e) {
                List<Occurrence> occurrences = new ArrayList<>();
                occurrences.add(occurrence);
                this.groupByParameter.put(parameters, occurrences);
            }
        });
    }

    protected void groupByParameter() {
        this.groupByParameter = new HashMap<>();
        while (!this.occurrences.isEmpty()) {
            Occurrence occurrence = this.occurrences.remove(0);
            String parameters = occurrence.getParameters().toString();
            try {
                this.groupByParameter.get(parameters).add(occurrence);
            } catch (Exception e) {
                List<Occurrence> occurrences = new ArrayList<>();
                occurrences.add(occurrence);
                this.groupByParameter.put(parameters, occurrences);
            }
        }
    }

    protected boolean isChangeful() {
        for (Map.Entry<String, List<Occurrence>> entry : this.groupByParameter.entrySet()) {
            if (entry.getValue().size() == 1) {
                continue;
            }
            Occurrence firstOccurrence = entry.getValue().get(0);
            for (Occurrence occurrence : entry.getValue()) {
                if (!occurrence.getReturnValue().equals(firstOccurrence.getReturnValue())) {
                    return true;
                }
            }
        }
        return false;
    }

    protected double getPotentialHitRatio() {
        double potentialHitRatio = 0;
        for (Map.Entry<String, List<Occurrence>> entry : this.groupByParameter.entrySet()) {
            potentialHitRatio += entry.getValue().size();
        }
        potentialHitRatio = (potentialHitRatio - this.groupByParameter.size()) / potentialHitRatio;
        this.groupByParameter.clear();
        return potentialHitRatio;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + Objects.hashCode(this.name);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Method)) {
            return false;
        }
        Method method = (Method) obj;
        return this.name.equals(method.name);
    }

    @Override
    public String toString() {
        return this.name;
    }

}
