/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.memoizeit;

import java.util.List;
import java.util.Map;

/**
 *
 * @author romulo
 */
public class Occurrence {

    private final Object returnValue;
    private final List<Object> parameters;
    private final long startTime;
    private final long endTime;
    private boolean truncated;

    public Occurrence(Object returnValue, List<Object> parameters, long startTime, long endTime) {
        this.returnValue = returnValue;
        this.parameters = parameters;
        this.startTime = startTime;
        this.endTime = endTime;
        this.truncated = true;
    }

    public Object getReturnValue() {
        return returnValue;
    }

    public List<Object> getParameters() {
        return parameters;
    }

    public long getExecutionTime() {
        return this.endTime - this.startTime;
    }

    private Object truncateObject(Object object, int depth) {
        if (depth == 0) {
            object = "...";
            this.truncated = true;
            return object;
        }
        if (object instanceof Map) {
            Map<String, Object> map = (Map<String, Object>) object;
            map.entrySet().forEach((entry) -> {
                entry.setValue(truncateObject(entry.getValue(), depth - 1));
            });
        } else if (object instanceof List) {
            List list = (List) object;
            for (int i = 0; i < list.size(); i++) {
                list.set(i, truncateObject(list.get(i), depth - 1));
            }
        }
        return object;
    }

    protected Occurrence getView(int depth) {
        if (!this.truncated) {
            return this;
        }
        this.truncated = false;
        Object returnValue = ObjectUtils.deepCopy(this.returnValue);
        truncateObject(returnValue, depth);
        List<Object> parameters = ObjectUtils.deepCopy(this.parameters);
        truncateObject(parameters, depth);
        Occurrence occurrence = new Occurrence(returnValue, parameters, startTime, endTime);
        return occurrence;
    }

}
