/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.memoizeit.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 *
 * @author romulo
 */
public class Graph<U> {

    private final Map<U, Node<U>> contentHasNode;

    public Graph() {
        this.contentHasNode = new HashMap<>();
    }

    public Graph(Map<U, Node<U>> contentHasNode) {
        this.contentHasNode = contentHasNode;
    }

    public Node<U> getNode(U content) {
        return this.contentHasNode.get(content);
    }

    public Collection<Node<U>> getNodes() {
        return this.contentHasNode.values();
    }

    public Collection<Edge<U>> getEdges() {
        return getNodes().stream()
                .map(node
                        -> node.getLinks().stream()
                        .map(link -> new Edge<>(node, link))
                        .collect(Collectors.toList()))
                .reduce(new ArrayList<>(), (a, b) -> {
                    List arrayList = new ArrayList<>(a);
                    arrayList.addAll(b);
                    return arrayList;
                });
    }

    public Collection<Node<U>> getRoots() {
        Collection<Node<U>> roots = new ArrayList<>(getNodes());
        getEdges().forEach(edge -> roots.remove(edge.getTarget()));
        return roots;
    }
}
