/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.memoizeit.graph;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;

/**
 *
 * @author romulo
 */
public class Node<U> {

    private final U content;
    private final Collection<Node<U>> links;

    public Node(U content) {
        this.content = content;
        this.links = new HashSet<>();
    }

    public U getContent() {
        return content;
    }

    public Node addLink(Node node) {
        links.add(node);
        return this;
    }

    public Collection<Node<U>> getLinks() {
        return links;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.content);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node other = (Node) obj;
        return this.content.equals(other.content);
    }

}
