/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.memoizeit;

import br.ufrgs.inf.prosoft.trace.Return;
import br.ufrgs.inf.prosoft.trace.TraceConcrete;
import br.ufrgs.inf.prosoft.trace.reader.Traces;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 *
 * @author romulo
 */
public class OccurrenceReference extends Occurrence {

    private final int index;
    private OccurrenceConcrete occurrenceConcrete;

    public OccurrenceReference(int index, String instance, long startTime, long endTime) {
        super(instance, startTime, endTime);
        this.index = index;
    }

    @Override
    public Object getReturnValue() {
        if (this.occurrenceConcrete != null) {
            return this.occurrenceConcrete.getReturnValue();
        }
        Return returnValue = Traces.getTraceReturn(this.index);
        return returnValue == null ? null : returnValue.getData();
    }

    @Override
    public List<Parameter> getParameters() {
        if (this.occurrenceConcrete != null) {
            return this.occurrenceConcrete.getParameters();
        }
        List<br.ufrgs.inf.prosoft.trace.Parameter> parameters = Traces.getTraceParameter(this.index);
        return parameters.stream()
                .map(parameter -> new Parameter(parameter.getType(), parameter.getData()))
                .collect(Collectors.toList());
    }

    @Override
    public OccurrenceConcrete getConcrete() {
        TraceConcrete traceConcrete = Traces.getTraceConcrete(this.index);
        Object returnValue = null;
        List<Parameter> parameters = new ArrayList<>();
        if (traceConcrete != null) {
            returnValue = traceConcrete.getReturn().getData();
            parameters = traceConcrete.getParameters().stream()
                    .map(parameter -> new Parameter(parameter.getType(), parameter.getData()))
                    .collect(Collectors.toList());
        }
        return new OccurrenceConcrete(getInstance(), returnValue, parameters, getStartTime(), getEndTime());
    }

    @Override
    public OccurrenceConcrete loadConcrete() {
        this.occurrenceConcrete = getConcrete();
        return this.occurrenceConcrete;
    }

    public OccurrenceReference cleanConcrete() {
        this.occurrenceConcrete = null;
        return this;
    }

}
