/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.memoizeit.adapter;

import br.ufrgs.inf.prosoft.memoizeit.graph.Graph;
import br.ufrgs.inf.prosoft.memoizeit.graph.Node;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

/**
 *
 * @author romulo
 */
public class CallGraphReader {

    private static final Logger logger = Logger.getLogger(CallGraphReader.class.getName());

    public static Graph<String> parseFile(String path) {
        try {
            Map<String, Node<String>> callHasNode = new HashMap<>();
            try (Stream<String> lines = Files.lines(Paths.get(path))) {
                lines.forEach(line -> {
                    if (line.charAt(0) != 'M') {
                        return;
                    }
                    int indexOfSpace = line.indexOf(" ");
                    String callerString = line.substring(2, indexOfSpace);
                    String calleeString = line.substring(indexOfSpace + 4, line.length());
                    callerString = reshapeMethodName(callerString);
                    calleeString = reshapeMethodName(calleeString);
                    Node<String> callerNode = callHasNode.get(callerString);
                    if (callerNode == null) {
                        callerNode = new Node<>(callerString);
                        callHasNode.put(callerString, callerNode);
                    }
                    Node<String> calleeNode = callHasNode.get(calleeString);
                    if (calleeNode == null) {
                        calleeNode = new Node<>(calleeString);
                        callHasNode.put(calleeString, calleeNode);
                    }
                    callerNode.addLink(calleeNode);
                });
            }
            return new Graph<>(callHasNode);
        } catch (IOException ex) {
            logger.log(Level.SEVERE, "Failed to open {0}", path);
        }
        return new Graph<>();
    }

    public static Map<String, Set<String>> parseFileToMap(String path) {
        Map<String, Set<String>> nodeHasLinks = new HashMap<>();
        try {
            try (Stream<String> lines = Files.lines(Paths.get(path))) {
                lines.forEach(line -> {
                    if (line.charAt(0) != 'M') {
                        return;
                    }
                    int indexOfSpace = line.indexOf(" ");
                    String callerString = line.substring(2, indexOfSpace);
                    String calleeString = line.substring(indexOfSpace + 4, line.length());
                    callerString = reshapeMethodName(callerString);
                    calleeString = reshapeMethodName(calleeString);
                    Set<String> links = nodeHasLinks.get(callerString);
                    if (links == null) {
                        links = new HashSet<>();
                        nodeHasLinks.put(callerString, links);
                    }
                    links.add(calleeString);
                });
            }
        } catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        return nodeHasLinks;
    }

    private static String reshapeMethodName(String methodName) {
        return methodName.substring(0, methodName.indexOf("("))
                .replace(":", ".")
                .replace("$", ".");
    }
}
