/*
 * Decompiled with CFR 0.152.
 */
package azkaban.webapp.servlet;

import azkaban.executor.ExecutorManagerAdapter;
import azkaban.executor.ExecutorManagerException;
import azkaban.project.ProjectManager;
import azkaban.webapp.AzkabanWebServer;
import azkaban.webapp.servlet.HistoryServlet;
import azkaban.webapp.servlet.LoginAbstractAzkabanServlet;
import azkaban.webapp.servlet.Page;
import azkaban.webapp.session.Session;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.format.DateTimeFormat;

public class HistoryServlet
extends LoginAbstractAzkabanServlet {
    private static final long serialVersionUID = 1L;
    private ExecutorManagerAdapter executorManager;
    private ProjectManager projectManager;
    private ExecutorVMHelper vmHelper;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        AzkabanWebServer server = (AzkabanWebServer)this.getApplication();
        this.executorManager = server.getExecutorManager();
        this.projectManager = server.getProjectManager();
        this.vmHelper = new ExecutorVMHelper(this);
    }

    protected void handleGet(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        if (this.hasParam(req, "ajax")) {
            this.handleAJAXAction(req, resp, session);
        } else if (this.hasParam(req, "days")) {
            this.handleHistoryDayPage(req, resp, session);
        } else if (this.hasParam(req, "timeline")) {
            this.handleHistoryTimelinePage(req, resp, session);
        } else {
            this.handleHistoryPage(req, resp, session);
        }
    }

    private void handleAJAXAction(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        HashMap ret = new HashMap();
        String ajaxName = this.getParam(req, "ajax");
        if (ajaxName.equals("fetch")) {
            this.fetchHistoryData(req, resp, ret);
        }
        if (ret != null) {
            this.writeJSON(resp, ret);
        }
    }

    private void fetchHistoryData(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> ret) throws ServletException {
    }

    private void handleHistoryPage(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException {
        Page page = this.newPage(req, resp, session, "azkaban/webapp/servlet/velocity/historypage.vm");
        int pageNum = this.getIntParam(req, "page", 1);
        int pageSize = this.getIntParam(req, "size", 16);
        page.add("vmutils", (Object)this.vmHelper);
        if (pageNum < 0) {
            pageNum = 1;
        }
        List history = null;
        if (this.hasParam(req, "advfilter")) {
            String projContain = this.getParam(req, "projcontain");
            String flowContain = this.getParam(req, "flowcontain");
            String userContain = this.getParam(req, "usercontain");
            int status = this.getIntParam(req, "status");
            String begin = this.getParam(req, "begin");
            long beginTime = begin == "" ? -1L : DateTimeFormat.forPattern((String)"MM/dd/yyyy-HH:mm").parseDateTime(begin).getMillis();
            String end = this.getParam(req, "end");
            long endTime = end == "" ? -1L : DateTimeFormat.forPattern((String)"MM/dd/yyyy-HH:mm").parseDateTime(end).getMillis();
            try {
                history = this.executorManager.getExecutableFlows(projContain, flowContain, userContain, status, beginTime, endTime, (pageNum - 1) * pageSize, pageSize);
            }
            catch (ExecutorManagerException e) {
                page.add("error", (Object)e.getMessage());
            }
        } else if (this.hasParam(req, "search")) {
            String searchTerm = this.getParam(req, "searchterm");
            try {
                history = this.executorManager.getExecutableFlows(searchTerm, (pageNum - 1) * pageSize, pageSize);
            }
            catch (ExecutorManagerException e) {
                page.add("error", (Object)e.getMessage());
            }
        } else {
            try {
                history = this.executorManager.getExecutableFlows((pageNum - 1) * pageSize, pageSize);
            }
            catch (ExecutorManagerException e) {
                e.printStackTrace();
            }
        }
        page.add("flowHistory", history);
        page.add("size", (Object)pageSize);
        page.add("page", (Object)pageNum);
        if (this.hasParam(req, "searchterm") && !this.getParam(req, "searchterm").equals("")) {
            page.add("search", (Object)"true");
            page.add("search_term", (Object)this.getParam(req, "searchterm"));
        }
        if (this.hasParam(req, "advfilter")) {
            page.add("advfilter", (Object)"true");
            page.add("projcontain", (Object)this.getParam(req, "projcontain"));
            page.add("flowcontain", (Object)this.getParam(req, "flowcontain"));
            page.add("usercontain", (Object)this.getParam(req, "usercontain"));
            page.add("status", (Object)this.getIntParam(req, "status"));
            page.add("begin", (Object)this.getParam(req, "begin"));
            page.add("end", (Object)this.getParam(req, "end"));
        }
        if (pageNum == 1) {
            page.add("previous", (Object)new PageSelection(this, 1, pageSize, true, false));
        } else {
            page.add("previous", (Object)new PageSelection(this, pageNum - 1, pageSize, false, false));
        }
        page.add("next", (Object)new PageSelection(this, pageNum + 1, pageSize, false, false));
        int pageStartValue = 1;
        if (pageNum > 3) {
            pageStartValue = pageNum - 2;
        }
        page.add("page1", (Object)new PageSelection(this, pageStartValue, pageSize, false, pageStartValue == pageNum));
        page.add("page2", (Object)new PageSelection(this, pageStartValue, pageSize, false, ++pageStartValue == pageNum));
        page.add("page3", (Object)new PageSelection(this, pageStartValue, pageSize, false, ++pageStartValue == pageNum));
        page.add("page4", (Object)new PageSelection(this, pageStartValue, pageSize, false, ++pageStartValue == pageNum));
        page.add("page5", (Object)new PageSelection(this, pageStartValue, pageSize, false, ++pageStartValue == pageNum));
        ++pageStartValue;
        page.render();
    }

    private void handleHistoryTimelinePage(HttpServletRequest req, HttpServletResponse resp, Session session) {
    }

    private void handleHistoryDayPage(HttpServletRequest req, HttpServletResponse resp, Session session) {
    }

    protected void handlePost(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
    }

    static /* synthetic */ ProjectManager access$0(HistoryServlet historyServlet) {
        return historyServlet.projectManager;
    }
}

