/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.sampled;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.CacheConfigurationListener;
import net.sf.ehcache.config.PinningConfiguration;
import net.sf.ehcache.config.TerracottaConfiguration;
import net.sf.ehcache.hibernate.management.impl.BaseEmitterBean;
import net.sf.ehcache.management.sampled.SampledCacheMBean;
import net.sf.ehcache.util.CacheTransactionHelper;
import net.sf.ehcache.writer.writebehind.WriteBehindManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampledCache
extends BaseEmitterBean
implements SampledCacheMBean,
CacheConfigurationListener,
PropertyChangeListener {
    private static final int PERCENTAGE_DIVISOR = 100;
    private static final Logger LOG = LoggerFactory.getLogger((String)SampledCache.class.getName());
    private static final MBeanNotificationInfo[] NOTIFICATION_INFO;
    private final Ehcache cache;
    private final String immutableCacheName;

    public SampledCache(Ehcache cache) throws NotCompliantMBeanException {
        super(SampledCacheMBean.class);
        this.cache = cache;
        this.immutableCacheName = cache.getName();
        cache.getCacheConfiguration().addConfigurationListener(this);
        cache.addPropertyChangeListener(this);
    }

    String getImmutableCacheName() {
        return this.immutableCacheName;
    }

    @Override
    public boolean isEnabled() {
        return !this.cache.isDisabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        try {
            this.cache.setDisabled(!enabled);
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    @Deprecated
    public boolean isClusterCoherent() {
        try {
            return this.cache.isClusterCoherent();
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    public boolean isClusterBulkLoadEnabled() {
        try {
            return this.cache.isClusterBulkLoadEnabled();
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    @Deprecated
    public boolean isNodeCoherent() {
        try {
            return this.cache.isNodeCoherent();
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    public boolean isNodeBulkLoadEnabled() {
        return !this.isNodeCoherent();
    }

    @Override
    @Deprecated
    public void setNodeCoherent(boolean coherent) {
        boolean isNodeCoherent = this.isNodeCoherent();
        if (coherent != isNodeCoherent) {
            if (!coherent && this.getTransactional()) {
                LOG.warn("a transactional cache cannot be incoherent");
                return;
            }
            try {
                this.cache.setNodeCoherent(coherent);
            }
            catch (RuntimeException e) {
                throw SampledCache.newPlainException(e);
            }
        }
    }

    @Override
    public void setNodeBulkLoadEnabled(boolean bulkLoadEnabled) {
        if (bulkLoadEnabled && this.getTransactional()) {
            LOG.warn("a transactional cache cannot be put into bulk-load mode");
            return;
        }
        this.setNodeCoherent(!bulkLoadEnabled);
    }

    static RuntimeException newPlainException(RuntimeException e) {
        String type = e.getClass().getName();
        if (type.startsWith("java.") || type.startsWith("javax.")) {
            return e;
        }
        RuntimeException result = new RuntimeException(e.getMessage());
        result.setStackTrace(e.getStackTrace());
        return result;
    }

    @Override
    public void flush() {
        try {
            this.cache.flush();
            this.sendNotification("CacheFlushed", this.getCacheAttributes(), this.getImmutableCacheName());
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    public String getCacheName() {
        return this.cache.getName();
    }

    @Override
    public String getStatus() {
        return this.cache.getStatus().toString();
    }

    @Override
    public void removeAll() {
        CacheTransactionHelper.beginTransactionIfNeeded(this.cache);
        try {
            this.cache.removeAll();
            this.sendNotification("CacheCleared", this.getCacheAttributes(), this.getImmutableCacheName());
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
        finally {
            try {
                CacheTransactionHelper.commitTransactionIfNeeded(this.cache);
            }
            catch (RuntimeException e2) {
                throw SampledCache.newPlainException(e2);
            }
        }
    }

    @Override
    public long getAverageGetTimeMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getAverageGetTimeMostRecentSample();
    }

    @Override
    public long getCacheEvictionRate() {
        return this.getCacheElementEvictedMostRecentSample();
    }

    @Override
    public long getCacheElementEvictedMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheElementEvictedMostRecentSample();
    }

    @Override
    public long getCacheExpirationRate() {
        return this.getCacheElementExpiredMostRecentSample();
    }

    @Override
    public long getCacheElementExpiredMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheElementExpiredMostRecentSample();
    }

    @Override
    public long getCachePutRate() {
        return this.getCacheElementPutMostRecentSample();
    }

    @Override
    public long getCacheElementPutMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheElementPutMostRecentSample();
    }

    @Override
    public long getCacheRemoveRate() {
        return this.getCacheElementRemovedMostRecentSample();
    }

    @Override
    public long getCacheElementRemovedMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheElementRemovedMostRecentSample();
    }

    @Override
    public long getCacheUpdateRate() {
        return this.getCacheElementUpdatedMostRecentSample();
    }

    @Override
    public long getCacheElementUpdatedMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheElementUpdatedMostRecentSample();
    }

    @Override
    public long getCacheInMemoryHitRate() {
        return this.getCacheHitInMemoryMostRecentSample();
    }

    @Override
    public long getCacheHitInMemoryMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheHitInMemoryMostRecentSample();
    }

    @Override
    public long getCacheOffHeapHitRate() {
        return this.getCacheHitOffHeapMostRecentSample();
    }

    @Override
    public long getCacheHitOffHeapMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheHitOffHeapMostRecentSample();
    }

    @Override
    public long getCacheHitRate() {
        return this.getCacheHitMostRecentSample();
    }

    @Override
    public long getCacheHitMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheHitMostRecentSample();
    }

    @Override
    public long getCacheOnDiskHitRate() {
        return this.getCacheHitOnDiskMostRecentSample();
    }

    @Override
    public long getCacheHitOnDiskMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheHitOnDiskMostRecentSample();
    }

    @Override
    public long getCacheMissExpiredMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheMissExpiredMostRecentSample();
    }

    @Override
    public long getCacheMissRate() {
        return this.getCacheMissMostRecentSample();
    }

    @Override
    public long getCacheMissMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheMissMostRecentSample();
    }

    @Override
    public long getCacheInMemoryMissRate() {
        return this.getCacheMissInMemoryMostRecentSample();
    }

    @Override
    public long getCacheMissInMemoryMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheMissInMemoryMostRecentSample();
    }

    @Override
    public long getCacheOffHeapMissRate() {
        return this.getCacheMissOffHeapMostRecentSample();
    }

    @Override
    public long getCacheMissOffHeapMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheMissOffHeapMostRecentSample();
    }

    @Override
    public long getCacheOnDiskMissRate() {
        return this.getCacheMissOnDiskMostRecentSample();
    }

    @Override
    public long getCacheMissOnDiskMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheMissOnDiskMostRecentSample();
    }

    @Override
    public long getCacheMissNotFoundMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheMissNotFoundMostRecentSample();
    }

    @Override
    public int getStatisticsAccuracy() {
        return this.cache.getSampledCacheStatistics().getStatisticsAccuracy();
    }

    @Override
    public String getStatisticsAccuracyDescription() {
        return this.cache.getSampledCacheStatistics().getStatisticsAccuracyDescription();
    }

    @Override
    public void clearStatistics() {
        try {
            this.cache.clearStatistics();
            this.sendNotification("CacheStatisticsReset", this.getCacheAttributes(), this.getImmutableCacheName());
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.cache.isStatisticsEnabled();
    }

    @Override
    public boolean isSampledStatisticsEnabled() {
        return this.cache.getSampledCacheStatistics().isSampledStatisticsEnabled();
    }

    @Override
    public boolean isTerracottaClustered() {
        return this.cache.getCacheConfiguration().isTerracottaClustered();
    }

    @Override
    public String getTerracottaConsistency() {
        TerracottaConfiguration.Consistency consistency = this.cache.getCacheConfiguration().getTerracottaConsistency();
        return consistency != null ? consistency.name() : "na";
    }

    @Override
    public String getTerracottaStorageStrategy() {
        TerracottaConfiguration.StorageStrategy storageStrategy = this.cache.getCacheConfiguration().getTerracottaStorageStrategy();
        return storageStrategy != null ? storageStrategy.name() : "na";
    }

    @Override
    public void enableStatistics() {
        if (!this.cache.isStatisticsEnabled()) {
            try {
                this.cache.setSampledStatisticsEnabled(true);
                this.cache.setStatisticsEnabled(true);
            }
            catch (RuntimeException e) {
                throw SampledCache.newPlainException(e);
            }
        }
    }

    @Override
    public void disableStatistics() {
        if (this.cache.isStatisticsEnabled()) {
            try {
                this.cache.setSampledStatisticsEnabled(false);
                this.cache.setStatisticsEnabled(false);
            }
            catch (RuntimeException e) {
                throw SampledCache.newPlainException(e);
            }
        }
    }

    @Override
    public void setStatisticsEnabled(boolean statsEnabled) {
        boolean oldValue = this.isStatisticsEnabled();
        if (oldValue != statsEnabled) {
            if (statsEnabled) {
                this.enableStatistics();
            } else {
                this.disableStatistics();
            }
        }
    }

    @Override
    public void enableSampledStatistics() {
        if (!this.cache.isSampledStatisticsEnabled()) {
            try {
                this.cache.setSampledStatisticsEnabled(true);
            }
            catch (RuntimeException e) {
                throw SampledCache.newPlainException(e);
            }
        }
    }

    @Override
    public void disableSampledStatistics() {
        if (this.cache.isSampledStatisticsEnabled()) {
            try {
                this.cache.setSampledStatisticsEnabled(false);
            }
            catch (RuntimeException e) {
                throw SampledCache.newPlainException(e);
            }
        }
    }

    @Override
    public float getCacheAverageGetTime() {
        return this.getAverageGetTimeMillis();
    }

    @Override
    public float getAverageGetTimeMillis() {
        try {
            return this.cache.getAverageGetTime();
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    public long getMaxGetTimeMillis() {
        try {
            return this.cache.getLiveCacheStatistics().getMaxGetTimeMillis();
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    public long getXaCommitCount() {
        try {
            return this.cache.getLiveCacheStatistics().getXaCommitCount();
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    public long getXaRollbackCount() {
        try {
            return this.cache.getLiveCacheStatistics().getXaRollbackCount();
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    public boolean getHasWriteBehindWriter() {
        return this.cache.getWriterManager() instanceof WriteBehindManager && this.cache.getRegisteredCacheWriter() != null;
    }

    @Override
    public long getWriterQueueLength() {
        try {
            return this.cache.getLiveCacheStatistics().getWriterQueueLength();
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    public int getWriterMaxQueueSize() {
        return this.cache.getCacheConfiguration().getCacheWriterConfiguration().getWriteBehindMaxQueueSize();
    }

    @Override
    public int getWriterConcurrency() {
        return this.cache.getCacheConfiguration().getCacheWriterConfiguration().getWriteBehindConcurrency();
    }

    @Override
    public long getMinGetTimeMillis() {
        try {
            return this.cache.getLiveCacheStatistics().getMinGetTimeMillis();
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    public long getCacheHitCount() {
        try {
            return this.cache.getLiveCacheStatistics().getCacheHitCount();
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    public long getCacheMissCount() {
        try {
            return this.cache.getLiveCacheStatistics().getCacheMissCount();
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    public long getInMemoryMissCount() {
        try {
            return this.cache.getLiveCacheStatistics().getInMemoryMissCount();
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    public long getOffHeapMissCount() {
        try {
            return this.cache.getLiveCacheStatistics().getOffHeapMissCount();
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    public long getOnDiskMissCount() {
        try {
            return this.cache.getLiveCacheStatistics().getOnDiskMissCount();
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    public long getCacheMissCountExpired() {
        try {
            return this.cache.getLiveCacheStatistics().getCacheMissCountExpired();
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    public long getDiskExpiryThreadIntervalSeconds() {
        return this.cache.getCacheConfiguration().getDiskExpiryThreadIntervalSeconds();
    }

    @Override
    public void setDiskExpiryThreadIntervalSeconds(long seconds) {
        if (this.getDiskExpiryThreadIntervalSeconds() != seconds) {
            try {
                this.cache.getCacheConfiguration().setDiskExpiryThreadIntervalSeconds(seconds);
            }
            catch (RuntimeException e) {
                throw SampledCache.newPlainException(e);
            }
        }
    }

    @Override
    public long getMaxEntriesLocalHeap() {
        return this.cache.getCacheConfiguration().getMaxEntriesLocalHeap();
    }

    @Override
    public void setMaxEntriesLocalHeap(long maxEntries) {
        if (this.getMaxEntriesLocalHeap() != maxEntries) {
            try {
                this.cache.getCacheConfiguration().setMaxEntriesLocalHeap(maxEntries);
                this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
            }
            catch (RuntimeException e) {
                throw SampledCache.newPlainException(e);
            }
        }
    }

    @Override
    public long getMaxBytesLocalHeap() {
        return this.cache.getCacheConfiguration().getMaxBytesLocalHeap();
    }

    @Override
    public void setMaxBytesLocalHeap(long maxBytes) {
        try {
            long heapPoolSize;
            if (this.cache.getCacheManager().getConfiguration().isMaxBytesLocalHeapSet() && maxBytes > (heapPoolSize = this.cache.getCacheManager().getConfiguration().getMaxBytesLocalHeap())) {
                throw new IllegalArgumentException("Requested maxBytesLocalHeap (" + maxBytes + ") greater than available CacheManager heap pool size (" + heapPoolSize + ")");
            }
            this.cache.getCacheConfiguration().setMaxBytesLocalHeap(maxBytes);
            this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    public void setMaxBytesLocalHeapAsString(String maxBytes) {
        try {
            this.cache.getCacheConfiguration().setMaxBytesLocalHeap(maxBytes);
            if (this.cache.getCacheConfiguration().isMaxBytesLocalHeapPercentageSet()) {
                long cacheAssignedMem = this.cache.getCacheManager().getConfiguration().getMaxBytesLocalHeap() * (long)this.cache.getCacheConfiguration().getMaxBytesLocalHeapPercentage().intValue() / 100L;
                this.setMaxBytesLocalHeap(cacheAssignedMem);
            } else {
                this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
            }
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    public String getMaxBytesLocalHeapAsString() {
        return this.cache.getCacheConfiguration().getMaxBytesLocalHeapAsString();
    }

    @Override
    public int getMaxElementsInMemory() {
        return this.cache.getCacheConfiguration().getMaxElementsInMemory();
    }

    @Override
    public void setMaxElementsInMemory(int maxElements) {
        if (this.getMaxElementsInMemory() != maxElements) {
            try {
                this.cache.getCacheConfiguration().setMaxElementsInMemory(maxElements);
                this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
            }
            catch (RuntimeException e) {
                throw SampledCache.newPlainException(e);
            }
        }
    }

    @Override
    public long getMaxEntriesLocalDisk() {
        return this.cache.getCacheConfiguration().getMaxEntriesLocalDisk();
    }

    @Override
    public void setMaxEntriesLocalDisk(long maxEntries) {
        if (this.getMaxEntriesLocalDisk() != maxEntries) {
            try {
                this.cache.getCacheConfiguration().setMaxEntriesLocalDisk(maxEntries);
                this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
            }
            catch (RuntimeException e) {
                throw SampledCache.newPlainException(e);
            }
        }
    }

    @Override
    public void setMaxBytesLocalDisk(long maxBytes) {
        try {
            long diskPoolSize;
            if (this.cache.getCacheManager().getConfiguration().isMaxBytesLocalDiskSet() && maxBytes > (diskPoolSize = this.cache.getCacheManager().getConfiguration().getMaxBytesLocalDisk())) {
                throw new IllegalArgumentException("Requested maxBytesLocalDisk (" + maxBytes + ") greater than available CacheManager disk pool size (" + diskPoolSize + ")");
            }
            this.cache.getCacheConfiguration().setMaxBytesLocalDisk(maxBytes);
            this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    public void setMaxBytesLocalDiskAsString(String maxBytes) {
        try {
            this.cache.getCacheConfiguration().setMaxBytesLocalDisk(maxBytes);
            if (this.cache.getCacheConfiguration().isMaxBytesLocalDiskPercentageSet()) {
                long cacheAssignedMem = this.cache.getCacheManager().getConfiguration().getMaxBytesLocalDisk() * (long)this.cache.getCacheConfiguration().getMaxBytesLocalDiskPercentage().intValue() / 100L;
                this.setMaxBytesLocalDisk(cacheAssignedMem);
            } else {
                this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
            }
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    public String getMaxBytesLocalDiskAsString() {
        return this.cache.getCacheConfiguration().getMaxBytesLocalDiskAsString();
    }

    @Override
    public int getMaxElementsOnDisk() {
        return this.cache.getCacheConfiguration().getMaxElementsOnDisk();
    }

    @Override
    public void setMaxElementsOnDisk(int maxElements) {
        if (this.getMaxElementsOnDisk() != maxElements) {
            try {
                this.cache.getCacheConfiguration().setMaxElementsOnDisk(maxElements);
                this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
            }
            catch (RuntimeException e) {
                throw SampledCache.newPlainException(e);
            }
        }
    }

    @Override
    public long getMaxBytesLocalDisk() {
        return this.cache.getCacheConfiguration().getMaxBytesLocalDisk();
    }

    @Override
    public long getMaxBytesLocalOffHeap() {
        return this.cache.getCacheConfiguration().getMaxBytesLocalOffHeap();
    }

    @Override
    public String getMaxBytesLocalOffHeapAsString() {
        return this.cache.getCacheConfiguration().getMaxBytesLocalOffHeapAsString();
    }

    @Override
    public String getMemoryStoreEvictionPolicy() {
        return this.cache.getCacheConfiguration().getMemoryStoreEvictionPolicy().toString();
    }

    @Override
    public void setMemoryStoreEvictionPolicy(String evictionPolicy) {
        if (!this.getMemoryStoreEvictionPolicy().equals(evictionPolicy)) {
            try {
                this.cache.getCacheConfiguration().setMemoryStoreEvictionPolicy(evictionPolicy);
                this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
            }
            catch (RuntimeException e) {
                throw SampledCache.newPlainException(e);
            }
        }
    }

    @Override
    public long getTimeToIdleSeconds() {
        return this.cache.getCacheConfiguration().getTimeToIdleSeconds();
    }

    @Override
    public void setTimeToIdleSeconds(long tti) {
        if (this.getTimeToIdleSeconds() != tti) {
            try {
                this.cache.getCacheConfiguration().setTimeToIdleSeconds(tti);
                this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
            }
            catch (RuntimeException e) {
                throw SampledCache.newPlainException(e);
            }
        }
    }

    @Override
    public long getTimeToLiveSeconds() {
        return this.cache.getCacheConfiguration().getTimeToLiveSeconds();
    }

    @Override
    public void setTimeToLiveSeconds(long ttl) {
        if (this.getTimeToLiveSeconds() != ttl) {
            try {
                this.cache.getCacheConfiguration().setTimeToLiveSeconds(ttl);
                this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
            }
            catch (RuntimeException e) {
                throw SampledCache.newPlainException(e);
            }
        }
    }

    @Override
    public boolean isDiskPersistent() {
        return this.cache.getCacheConfiguration().isDiskPersistent();
    }

    @Override
    public void setDiskPersistent(boolean diskPersistent) {
        if (this.isDiskPersistent() != diskPersistent) {
            try {
                this.cache.getCacheConfiguration().setDiskPersistent(diskPersistent);
                this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
            }
            catch (RuntimeException e) {
                throw SampledCache.newPlainException(e);
            }
        }
    }

    @Override
    public boolean isEternal() {
        return this.cache.getCacheConfiguration().isEternal();
    }

    @Override
    public void setEternal(boolean eternal) {
        if (this.isEternal() != eternal) {
            try {
                this.cache.getCacheConfiguration().setEternal(eternal);
                this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
            }
            catch (RuntimeException e) {
                throw SampledCache.newPlainException(e);
            }
        }
    }

    @Override
    public boolean isOverflowToDisk() {
        return this.cache.getCacheConfiguration().isOverflowToDisk();
    }

    @Override
    public void setOverflowToDisk(boolean overflowToDisk) {
        if (this.isOverflowToDisk() != overflowToDisk) {
            try {
                this.cache.getCacheConfiguration().setOverflowToDisk(overflowToDisk);
                this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
            }
            catch (RuntimeException e) {
                throw SampledCache.newPlainException(e);
            }
        }
    }

    @Override
    public boolean isLoggingEnabled() {
        return this.cache.getCacheConfiguration().getLogging();
    }

    @Override
    public void setLoggingEnabled(boolean enabled) {
        if (this.isLoggingEnabled() != enabled) {
            try {
                this.cache.getCacheConfiguration().setLogging(enabled);
                this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
            }
            catch (RuntimeException e) {
                throw SampledCache.newPlainException(e);
            }
        }
    }

    @Override
    public boolean isPinned() {
        return this.cache.getCacheConfiguration().getPinningConfiguration() != null;
    }

    @Override
    public String getPinnedToStore() {
        PinningConfiguration pinningConfig = this.cache.getCacheConfiguration().getPinningConfiguration();
        return pinningConfig != null ? pinningConfig.getStore().name() : "na";
    }

    @Override
    public long getEvictedCount() {
        try {
            return this.cache.getLiveCacheStatistics().getEvictedCount();
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    public long getExpiredCount() {
        try {
            return this.cache.getLiveCacheStatistics().getExpiredCount();
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    public long getInMemoryHitCount() {
        try {
            return this.cache.getLiveCacheStatistics().getInMemoryHitCount();
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    @Deprecated
    public long getInMemorySize() {
        return this.getLocalHeapSize();
    }

    @Override
    public long getOffHeapHitCount() {
        try {
            return this.cache.getLiveCacheStatistics().getOffHeapHitCount();
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    @Deprecated
    public long getOffHeapSize() {
        return this.getLocalOffHeapSize();
    }

    @Override
    public long getOnDiskHitCount() {
        try {
            return this.cache.getLiveCacheStatistics().getOnDiskHitCount();
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    @Deprecated
    public long getOnDiskSize() {
        return this.getLocalDiskSize();
    }

    @Override
    public long getLocalDiskSize() {
        try {
            return this.cache.getLiveCacheStatistics().getLocalDiskSize();
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    public long getLocalHeapSize() {
        try {
            return this.cache.getLiveCacheStatistics().getLocalHeapSize();
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    public long getLocalOffHeapSize() {
        try {
            return this.cache.getLiveCacheStatistics().getLocalOffHeapSize();
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    public long getLocalDiskSizeInBytes() {
        try {
            return this.cache.getLiveCacheStatistics().getLocalDiskSizeInBytes();
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    private boolean isCacheManagerPooled() {
        return this.cache.getCacheManager().getConfiguration().isMaxBytesLocalHeapSet() || this.cache.getCacheManager().getConfiguration().isMaxBytesLocalOffHeapSet() || this.cache.getCacheManager().getConfiguration().isMaxBytesLocalDiskSet();
    }

    @Override
    public long getLocalHeapSizeInBytes() {
        try {
            return this.cache.getLiveCacheStatistics().getLocalHeapSizeInBytes();
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    public long getLocalOffHeapSizeInBytes() {
        try {
            return this.cache.getLiveCacheStatistics().getLocalOffHeapSizeInBytes();
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    public long getPutCount() {
        try {
            return this.cache.getLiveCacheStatistics().getPutCount();
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    public long getRemovedCount() {
        try {
            return this.cache.getLiveCacheStatistics().getRemovedCount();
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    public long getSize() {
        try {
            return this.cache.getLiveCacheStatistics().getSize();
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    @Override
    public long getUpdateCount() {
        try {
            return this.cache.getLiveCacheStatistics().getUpdateCount();
        }
        catch (RuntimeException e) {
            throw SampledCache.newPlainException(e);
        }
    }

    public Map<String, Object> getCacheAttributes() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("Enabled", this.isEnabled());
        result.put("TerracottaClustered", this.isTerracottaClustered());
        result.put("LoggingEnabled", this.isLoggingEnabled());
        result.put("TimeToIdleSeconds", this.getTimeToIdleSeconds());
        result.put("TimeToLiveSeconds", this.getTimeToLiveSeconds());
        result.put("MaxEntriesLocalHeap", this.getMaxEntriesLocalHeap());
        result.put("MaxEntriesLocalDisk", this.getMaxEntriesLocalDisk());
        result.put("MaxBytesLocalHeapAsString", this.getMaxBytesLocalHeapAsString());
        result.put("MaxBytesLocalOffHeapAsString", this.getMaxBytesLocalOffHeapAsString());
        result.put("MaxBytesLocalDiskAsString", this.getMaxBytesLocalDiskAsString());
        result.put("MaxBytesLocalHeap", this.getMaxBytesLocalHeap());
        result.put("MaxBytesLocalOffHeap", this.getMaxBytesLocalOffHeap());
        result.put("MaxBytesLocalDisk", this.getMaxBytesLocalDisk());
        result.put("DiskPersistent", this.isDiskPersistent());
        result.put("Eternal", this.isEternal());
        result.put("OverflowToDisk", this.isOverflowToDisk());
        result.put("DiskExpiryThreadIntervalSeconds", this.getDiskExpiryThreadIntervalSeconds());
        result.put("MemoryStoreEvictionPolicy", this.getMemoryStoreEvictionPolicy());
        result.put("TerracottaConsistency", this.getTerracottaConsistency());
        if (this.isTerracottaClustered()) {
            result.put("NodeBulkLoadEnabled", this.isNodeBulkLoadEnabled());
            result.put("NodeCoherent", this.isNodeCoherent());
            result.put("ClusterBulkLoadEnabled", this.isClusterBulkLoadEnabled());
            result.put("ClusterCoherent", this.isClusterCoherent());
        }
        result.put("StatisticsEnabled", this.isStatisticsEnabled());
        result.put("WriterConcurrency", this.getWriterConcurrency());
        result.put("Transactional", this.getTransactional());
        result.put("PinnedToStore", this.getPinnedToStore());
        return result;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return NOTIFICATION_INFO;
    }

    @Override
    public void deregistered(CacheConfiguration config) {
    }

    @Override
    public void maxBytesLocalHeapChanged(long oldValue, long newValue) {
        if (oldValue != newValue) {
            this.setMaxBytesLocalHeap(newValue);
        }
    }

    @Override
    public void maxBytesLocalDiskChanged(long oldValue, long newValue) {
        if (oldValue != newValue) {
            this.setMaxBytesLocalDisk(newValue);
        }
    }

    @Override
    public void diskCapacityChanged(int oldCapacity, int newCapacity) {
        if (oldCapacity != newCapacity) {
            this.setMaxElementsOnDisk(newCapacity);
        }
    }

    @Override
    public void loggingChanged(boolean oldValue, boolean newValue) {
        if (oldValue != newValue) {
            this.setLoggingEnabled(newValue);
        }
    }

    @Override
    public void memoryCapacityChanged(int oldCapacity, int newCapacity) {
        if (oldCapacity != newCapacity) {
            this.setMaxElementsInMemory(newCapacity);
        }
    }

    @Override
    public void registered(CacheConfiguration config) {
    }

    @Override
    public void timeToIdleChanged(long oldTimeToIdle, long newTimeToIdle) {
        if (oldTimeToIdle != newTimeToIdle) {
            this.setTimeToIdleSeconds(newTimeToIdle);
        }
    }

    @Override
    public void timeToLiveChanged(long oldTimeToLive, long newTimeToLive) {
        if (oldTimeToLive != newTimeToLive) {
            this.setTimeToLiveSeconds(newTimeToLive);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    protected void doDispose() {
        this.cache.getCacheConfiguration().removeConfigurationListener(this);
    }

    @Override
    public long getAverageSearchTime() {
        return this.cache.getAverageSearchTime();
    }

    @Override
    public long getSearchesPerSecond() {
        return this.cache.getSearchesPerSecond();
    }

    @Override
    public boolean getTransactional() {
        return this.cache.getCacheConfiguration().getTransactionalMode().isTransactional();
    }

    @Override
    public boolean getSearchable() {
        return this.cache.getCacheConfiguration().getSearchable() != null;
    }

    @Override
    public long getCacheSearchRate() {
        return this.cache.getSampledCacheStatistics().getSearchesPerSecond();
    }

    @Override
    public long getCacheAverageSearchTime() {
        return this.cache.getSampledCacheStatistics().getAverageSearchTime();
    }

    @Override
    public long getTransactionCommitRate() {
        return this.getCacheXaCommitsMostRecentSample();
    }

    @Override
    public long getCacheXaCommitsMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheXaCommitsMostRecentSample();
    }

    @Override
    public long getTransactionRollbackRate() {
        return this.getCacheXaRollbacksMostRecentSample();
    }

    @Override
    public long getCacheXaRollbacksMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheXaRollbacksMostRecentSample();
    }

    static {
        String[] notifTypes = new String[]{"CacheEnabled", "CacheChanged", "CacheFlushed", "CacheStatisticsEnabled", "CacheStatisticsReset"};
        String name = Notification.class.getName();
        String description = "Ehcache SampledCache Event";
        NOTIFICATION_INFO = new MBeanNotificationInfo[]{new MBeanNotificationInfo(notifTypes, name, "Ehcache SampledCache Event")};
    }
}

