/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util;

import java.util.ArrayList;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ConstantExpression;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POBinCond;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.builtin.IsEmpty;
import org.apache.pig.data.NonSpillableDataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;

public class CompilerUtils {
    public static void addEmptyBagOuterJoin(PhysicalPlan fePlan, Schema inputSchema) throws PlanException {
        POProject relationProject = (POProject)fePlan.getRoots().get(0);
        try {
            POProject relationProjectForIsEmpty = relationProject.clone();
            fePlan.add(relationProjectForIsEmpty);
            String scope = relationProject.getOperatorKey().scope;
            FuncSpec isEmptySpec = new FuncSpec(IsEmpty.class.getName());
            Object f = PigContext.instantiateFuncFromSpec(isEmptySpec);
            POUserFunc isEmpty = new POUserFunc(new OperatorKey(scope, NodeIdGenerator.getGenerator().getNextNodeId(scope)), -1, null, isEmptySpec, (EvalFunc)f);
            isEmpty.setResultType((byte)5);
            fePlan.add(isEmpty);
            fePlan.connect(relationProjectForIsEmpty, isEmpty);
            ConstantExpression ce = new ConstantExpression(new OperatorKey(scope, NodeIdGenerator.getGenerator().getNextNodeId(scope)));
            Tuple t = TupleFactory.getInstance().newTuple(inputSchema.size());
            for (int i = 0; i < inputSchema.size(); ++i) {
                t.set(i, null);
            }
            ArrayList<Tuple> bagContents = new ArrayList<Tuple>(1);
            bagContents.add(t);
            NonSpillableDataBag bg = new NonSpillableDataBag(bagContents);
            ce.setValue(bg);
            ce.setResultType((byte)120);
            fePlan.add(ce);
            POBinCond bincond = new POBinCond(new OperatorKey(scope, NodeIdGenerator.getGenerator().getNextNodeId(scope)));
            bincond.setCond(isEmpty);
            bincond.setLhs(ce);
            bincond.setRhs(relationProject);
            bincond.setResultType((byte)120);
            fePlan.add(bincond);
            fePlan.connect(isEmpty, bincond);
            fePlan.connect(ce, bincond);
            fePlan.connect(relationProject, bincond);
        }
        catch (Exception e) {
            throw new PlanException("Error setting up outerjoin", e);
        }
    }
}

