/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.relational;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.ResourceSchema;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.logical.Util;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LOLoad
extends LogicalRelationalOperator {
    private LogicalSchema scriptSchema;
    private FileSpec fs;
    private transient LoadFunc loadFunc;
    private transient Configuration conf;
    private LogicalSchema determinedSchema;
    private List<Integer> requiredFields = null;
    private boolean castInserted = false;
    private LogicalSchema uidOnlySchema;
    private String schemaFile = null;
    private String signature = null;

    public LOLoad(FileSpec loader, LogicalSchema schema, LogicalPlan plan, Configuration conf) {
        super("LOLoad", plan);
        this.scriptSchema = schema;
        this.fs = loader;
        if (loader != null) {
            this.schemaFile = loader.getFileName();
        }
        this.conf = conf;
    }

    public String getSchemaFile() {
        return this.schemaFile;
    }

    public LoadFunc getLoadFunc() throws FrontendException {
        try {
            if (this.loadFunc == null && this.fs != null) {
                this.loadFunc = (LoadFunc)PigContext.instantiateFuncFromSpec(this.fs.getFuncSpec());
                this.loadFunc.setUDFContextSignature(this.signature);
            }
            return this.loadFunc;
        }
        catch (ClassCastException cce) {
            throw new FrontendException(this, this.fs.getFuncSpec() + " should implement the LoadFunc interface.", 2236);
        }
    }

    public void setScriptSchema(LogicalSchema schema) {
        this.scriptSchema = schema;
    }

    public void setRequiredFields(List<Integer> requiredFields) {
        this.requiredFields = requiredFields;
    }

    @Override
    public LogicalSchema getSchema() throws FrontendException {
        int i;
        if (this.schema != null) {
            return this.schema;
        }
        LogicalSchema originalSchema = null;
        if (this.determinedSchema == null) {
            this.determinedSchema = this.getSchemaFromMetaData();
        }
        if (this.scriptSchema != null && this.determinedSchema != null) {
            originalSchema = LogicalSchema.merge(this.scriptSchema, this.determinedSchema, LogicalSchema.MergeMode.LoadForEach);
        } else if (this.scriptSchema != null) {
            originalSchema = this.scriptSchema;
        } else if (this.determinedSchema != null) {
            originalSchema = this.determinedSchema;
        }
        if (this.isCastInserted()) {
            for (i = 0; i < originalSchema.size(); ++i) {
                LogicalSchema.LogicalFieldSchema fs = originalSchema.getField(i);
                fs.type = this.determinedSchema == null ? (byte)50 : this.determinedSchema.getField((int)i).type;
            }
        }
        if (originalSchema != null) {
            this.uidOnlySchema = originalSchema.mergeUid(this.uidOnlySchema);
        }
        if (this.requiredFields != null) {
            this.schema = new LogicalSchema();
            for (i = 0; i < originalSchema.size(); ++i) {
                if (!this.requiredFields.contains(i)) continue;
                this.schema.addField(originalSchema.getField(i));
            }
        } else {
            this.schema = originalSchema;
        }
        return this.schema;
    }

    private LogicalSchema getSchemaFromMetaData() throws FrontendException {
        if (this.getLoadFunc() != null && this.getLoadFunc() instanceof LoadMetadata) {
            try {
                ResourceSchema resourceSchema = ((LoadMetadata)((Object)this.loadFunc)).getSchema(this.getFileSpec().getFileName(), new Job(this.conf));
                Schema oldSchema = Schema.getPigSchema(resourceSchema);
                return Util.translateSchema(oldSchema);
            }
            catch (IOException e) {
                throw new FrontendException((Operator)this, "Cannot get schema from loadFunc " + this.loadFunc.getClass().getName(), 2245, (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void setAlias(String alias) {
        super.setAlias(alias);
        this.storeScriptSchema();
        if (this.signature == null) {
            this.signature = alias;
        }
    }

    private void storeScriptSchema() {
        String alias = this.getAlias();
        if (this.conf != null && alias != null && this.scriptSchema != null) {
            try {
                this.conf.set(alias + ".scriptSchema", ObjectSerializer.serialize(Util.translateSchema(this.scriptSchema)));
            }
            catch (IOException ioe) {
                int errCode = 1018;
                String msg = "Problem serializing script schema";
                FrontendException fee = new FrontendException(this, msg, errCode, 2, false, null, ioe);
                throw new RuntimeException(fee);
            }
        }
    }

    public FileSpec getFileSpec() {
        return this.fs;
    }

    @Override
    public void accept(PlanVisitor v) throws FrontendException {
        if (!(v instanceof LogicalRelationalNodesVisitor)) {
            throw new FrontendException("Expected LogicalPlanVisitor", 2223);
        }
        ((LogicalRelationalNodesVisitor)v).visit(this);
    }

    public LogicalSchema getDeterminedSchema() {
        return this.determinedSchema;
    }

    @Override
    public boolean isEqual(Operator other) throws FrontendException {
        if (other != null && other instanceof LOLoad) {
            LOLoad ol = (LOLoad)other;
            if (!this.checkEquality(ol)) {
                return false;
            }
            if (this.fs == null) {
                return ol.fs == null;
            }
            return this.fs.equals(ol.fs);
        }
        return false;
    }

    public void setCastInserted(boolean flag) {
        this.castInserted = flag;
    }

    public boolean isCastInserted() {
        return this.castInserted;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public void resetUid() {
        this.uidOnlySchema = null;
    }

    @Override
    public String toString() {
        String str = super.toString();
        return str + "RequiredFields:" + this.requiredFields;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
        this.loadFunc.setUDFContextSignature(signature);
    }
}

