/*
 * Decompiled with CFR 0.152.
 */
package azkaban.scheduler;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutorManager;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.Status;
import azkaban.scheduler.Schedule;
import azkaban.scheduler.ScheduleManager;
import azkaban.scheduler.ScheduleManagerException;
import azkaban.utils.JSONUtils;
import azkaban.webapp.AzkabanWebServer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public class ScheduleStatisticManager {
    private static HashMap<Integer, Object> cacheLock = new HashMap();
    private static File cacheDirectory;
    private static final int STAT_NUMBERS = 10;

    public static Map<String, Object> getStatistics(int scheduleId, AzkabanWebServer server) throws ScheduleManagerException {
        Map data;
        if (cacheDirectory == null) {
            ScheduleStatisticManager.setCacheFolder((File)new File(server.getServerProps().getString("cache.directory", "cache")));
        }
        if ((data = ScheduleStatisticManager.loadCache((int)scheduleId)) != null) {
            return data;
        }
        data = ScheduleStatisticManager.calculateStats((int)scheduleId, (AzkabanWebServer)server);
        ScheduleStatisticManager.saveCache((int)scheduleId, (Map)data);
        return data;
    }

    private static Map<String, Object> calculateStats(int scheduleId, AzkabanWebServer server) throws ScheduleManagerException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ExecutorManager executorManager = server.getExecutorManager();
        ScheduleManager scheduleManager = server.getScheduleManager();
        Schedule schedule = scheduleManager.getSchedule(scheduleId);
        try {
            List executables = executorManager.getExecutableFlows(schedule.getProjectId(), schedule.getFlowName(), 0, 10, Status.SUCCEEDED);
            long average = 0L;
            long min = Integer.MAX_VALUE;
            long max = 0L;
            if (executables.isEmpty()) {
                average = 0L;
                min = 0L;
                max = 0L;
            } else {
                for (ExecutableFlow flow : executables) {
                    long time = flow.getEndTime() - flow.getStartTime();
                    average += time;
                    if (time < min) {
                        min = time;
                    }
                    if (time <= max) continue;
                    max = time;
                }
                average /= (long)executables.size();
            }
            data.put("average", average);
            data.put("min", min);
            data.put("max", max);
        }
        catch (ExecutorManagerException e) {
            e.printStackTrace();
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidateCache(int scheduleId, File cacheDir) {
        ScheduleStatisticManager.setCacheFolder((File)cacheDir);
        try {
            Object lock;
            Object object = lock = ScheduleStatisticManager.getLock((int)scheduleId);
            synchronized (object) {
                ScheduleStatisticManager.getCacheFile((int)scheduleId).delete();
            }
            ScheduleStatisticManager.unLock((int)scheduleId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveCache(int scheduleId, Map<String, Object> data) {
        Object lock = ScheduleStatisticManager.getLock((int)scheduleId);
        try {
            Object object = lock;
            synchronized (object) {
                File cache = ScheduleStatisticManager.getCacheFile((int)scheduleId);
                cache.createNewFile();
                FileOutputStream output = new FileOutputStream(cache);
                try {
                    JSONUtils.toJSON(data, (OutputStream)output, (boolean)false);
                }
                finally {
                    ((OutputStream)output).close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ScheduleStatisticManager.unLock((int)scheduleId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> loadCache(int scheduleId) {
        Object lock = ScheduleStatisticManager.getLock((int)scheduleId);
        try {
            Object object = lock;
            synchronized (object) {
                Object dataObj;
                File cache = ScheduleStatisticManager.getCacheFile((int)scheduleId);
                if (cache.exists() && cache.isFile() && (dataObj = JSONUtils.parseJSONFromFile((File)cache)) instanceof Map) {
                    Map data = (Map)dataObj;
                    return data;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ScheduleStatisticManager.unLock((int)scheduleId);
        return null;
    }

    private static File getCacheFile(int scheduleId) {
        cacheDirectory.mkdirs();
        File file = new File(cacheDirectory, String.valueOf(scheduleId) + ".cache");
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getLock(int scheduleId) {
        Object lock = null;
        HashMap hashMap = cacheLock;
        synchronized (hashMap) {
            lock = cacheLock.get(scheduleId);
            if (lock == null) {
                lock = new Object();
                cacheLock.put(scheduleId, lock);
            }
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unLock(int scheduleId) {
        HashMap hashMap = cacheLock;
        synchronized (hashMap) {
            cacheLock.remove(scheduleId);
        }
    }

    private static void setCacheFolder(File cacheDir) {
        if (cacheDirectory == null) {
            cacheDirectory = new File(cacheDir, "schedule-statistics");
        }
    }
}

