/*
 * Decompiled with CFR 0.152.
 */
package azkaban.webapp;

import azkaban.alert.Alerter;
import azkaban.database.AzkabanDatabaseSetup;
import azkaban.executor.ExecutorLoader;
import azkaban.executor.ExecutorManager;
import azkaban.executor.ExecutorManagerAdapter;
import azkaban.executor.JdbcExecutorLoader;
import azkaban.jmx.JmxExecutorManager;
import azkaban.jmx.JmxJettyServer;
import azkaban.jmx.JmxTriggerManager;
import azkaban.project.JdbcProjectLoader;
import azkaban.project.ProjectLoader;
import azkaban.project.ProjectManager;
import azkaban.scheduler.ScheduleLoader;
import azkaban.scheduler.ScheduleManager;
import azkaban.scheduler.TriggerBasedScheduleLoader;
import azkaban.trigger.JdbcTriggerLoader;
import azkaban.trigger.TriggerLoader;
import azkaban.trigger.TriggerManager;
import azkaban.trigger.TriggerManagerAdapter;
import azkaban.trigger.TriggerManagerException;
import azkaban.trigger.builtin.BasicTimeChecker;
import azkaban.trigger.builtin.CreateTriggerAction;
import azkaban.trigger.builtin.ExecuteFlowAction;
import azkaban.trigger.builtin.ExecutionChecker;
import azkaban.trigger.builtin.KillExecutionAction;
import azkaban.trigger.builtin.SlaAlertAction;
import azkaban.trigger.builtin.SlaChecker;
import azkaban.user.UserManager;
import azkaban.user.XmlUserManager;
import azkaban.utils.Emailer;
import azkaban.utils.FileIOUtils;
import azkaban.utils.Props;
import azkaban.utils.PropsUtils;
import azkaban.utils.Utils;
import azkaban.webapp.AzkabanServer;
import azkaban.webapp.plugin.PluginRegistry;
import azkaban.webapp.plugin.TriggerPlugin;
import azkaban.webapp.plugin.ViewerPlugin;
import azkaban.webapp.servlet.AbstractAzkabanServlet;
import azkaban.webapp.servlet.ExecutorServlet;
import azkaban.webapp.servlet.HistoryServlet;
import azkaban.webapp.servlet.IndexRedirectServlet;
import azkaban.webapp.servlet.JMXHttpServlet;
import azkaban.webapp.servlet.ProjectManagerServlet;
import azkaban.webapp.servlet.ProjectServlet;
import azkaban.webapp.servlet.ScheduleServlet;
import azkaban.webapp.servlet.TriggerManagerServlet;
import azkaban.webapp.session.SessionCache;
import com.linkedin.restli.server.RestliServlet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.log.Log4JLogChute;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.runtime.resource.loader.JarResourceLoader;
import org.joda.time.DateTimeZone;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;

/*
 * Exception performing whole class analysis ignored.
 */
public class AzkabanWebServer
extends AzkabanServer {
    private static final Logger logger = Logger.getLogger(AzkabanWebServer.class);
    public static final String AZKABAN_HOME = "AZKABAN_HOME";
    public static final String DEFAULT_CONF_PATH = "conf";
    public static final String AZKABAN_PROPERTIES_FILE = "azkaban.properties";
    public static final String AZKABAN_PRIVATE_PROPERTIES_FILE = "azkaban.private.properties";
    private static final int MAX_FORM_CONTENT_SIZE = 0xA00000;
    private static final int MAX_HEADER_BUFFER_SIZE = 0xA00000;
    private static AzkabanWebServer app;
    private static final String DEFAULT_TIMEZONE_ID = "default.timezone.id";
    private static final int DEFAULT_PORT_NUMBER = 8081;
    private static final int DEFAULT_SSL_PORT_NUMBER = 8443;
    private static final int DEFAULT_THREAD_NUMBER = 20;
    private static final String VELOCITY_DEV_MODE_PARAM = "velocity.dev.mode";
    private static final String USER_MANAGER_CLASS_PARAM = "user.manager.class";
    private static final String DEFAULT_STATIC_DIR = "";
    private final VelocityEngine velocityEngine;
    private final Server server;
    private UserManager userManager;
    private ProjectManager projectManager;
    private ExecutorManager executorManager;
    private ScheduleManager scheduleManager;
    private TriggerManager triggerManager;
    private Map<String, Alerter> alerters;
    private final ClassLoader baseClassLoader;
    private Props props;
    private SessionCache sessionCache;
    private File tempDir;
    private Map<String, TriggerPlugin> triggerPlugins;
    private MBeanServer mbeanServer;
    private ArrayList<ObjectName> registeredMBeans = new ArrayList();

    public static AzkabanWebServer getInstance() {
        return app;
    }

    public AzkabanWebServer() throws Exception {
        this(null, AzkabanWebServer.loadConfigurationFromAzkabanHome());
    }

    public AzkabanWebServer(Server server, Props props) throws Exception {
        this.props = props;
        this.server = server;
        this.velocityEngine = this.configureVelocityEngine(props.getBoolean("velocity.dev.mode", false));
        this.sessionCache = new SessionCache(props);
        this.userManager = this.loadUserManager(props);
        this.alerters = this.loadAlerters(props);
        this.executorManager = this.loadExecutorManager(props);
        this.projectManager = this.loadProjectManager(props);
        this.triggerManager = this.loadTriggerManager(props);
        this.loadBuiltinCheckersAndActions();
        this.scheduleManager = this.loadScheduleManager(this.triggerManager, props);
        String triggerPluginDir = props.getString("trigger.plugin.dir", "plugins/triggers");
        this.loadPluginCheckersAndActions(triggerPluginDir);
        this.baseClassLoader = this.getClassLoader();
        this.tempDir = new File(props.getString("azkaban.temp.dir", "temp"));
        if (props.containsKey((Object)"default.timezone.id")) {
            String timezone = props.getString("default.timezone.id");
            System.setProperty("user.timezone", timezone);
            TimeZone.setDefault(TimeZone.getTimeZone(timezone));
            DateTimeZone.setDefault((DateTimeZone)DateTimeZone.forID((String)timezone));
            logger.info((Object)("Setting timezone to " + timezone));
        }
        this.configureMBeanServer();
    }

    private void setTriggerPlugins(Map<String, TriggerPlugin> triggerPlugins) {
        this.triggerPlugins = triggerPlugins;
    }

    private UserManager loadUserManager(Props props) {
        Class userManagerClass = props.getClass("user.manager.class", null);
        logger.info((Object)("Loading user manager class " + userManagerClass.getName()));
        XmlUserManager manager = null;
        if (userManagerClass != null && userManagerClass.getConstructors().length > 0) {
            try {
                Constructor userManagerConstructor = userManagerClass.getConstructor(Props.class);
                manager = (UserManager)userManagerConstructor.newInstance(props);
            }
            catch (Exception e) {
                logger.error((Object)("Could not instantiate UserManager " + userManagerClass.getName()));
                throw new RuntimeException(e);
            }
        } else {
            manager = new XmlUserManager(props);
        }
        return manager;
    }

    private ProjectManager loadProjectManager(Props props) {
        logger.info((Object)"Loading JDBC for project management");
        JdbcProjectLoader loader = new JdbcProjectLoader(props);
        ProjectManager manager = new ProjectManager((ProjectLoader)loader, props);
        return manager;
    }

    private ExecutorManager loadExecutorManager(Props props) throws Exception {
        JdbcExecutorLoader loader = new JdbcExecutorLoader(props);
        ExecutorManager execManager = new ExecutorManager(props, (ExecutorLoader)loader, this.alerters);
        return execManager;
    }

    private ScheduleManager loadScheduleManager(TriggerManager tm, Props props) throws Exception {
        logger.info((Object)"Loading trigger based scheduler");
        TriggerBasedScheduleLoader loader = new TriggerBasedScheduleLoader(tm, "SimpleTimeTrigger");
        return new ScheduleManager((ScheduleLoader)loader);
    }

    private TriggerManager loadTriggerManager(Props props) throws TriggerManagerException {
        JdbcTriggerLoader loader = new JdbcTriggerLoader(props);
        return new TriggerManager(props, (TriggerLoader)loader, this.executorManager);
    }

    private void loadBuiltinCheckersAndActions() {
        logger.info((Object)"Loading built-in checker and action types");
        if (this.triggerManager instanceof TriggerManager) {
            SlaChecker.setExecutorManager((ExecutorManagerAdapter)this.executorManager);
            ExecuteFlowAction.setExecutorManager((ExecutorManagerAdapter)this.executorManager);
            ExecuteFlowAction.setProjectManager((ProjectManager)this.projectManager);
            ExecuteFlowAction.setTriggerManager((TriggerManager)this.triggerManager);
            KillExecutionAction.setExecutorManager((ExecutorManagerAdapter)this.executorManager);
            SlaAlertAction.setExecutorManager((ExecutorManagerAdapter)this.executorManager);
            SlaAlertAction.setAlerters((Map)this.alerters);
            SlaAlertAction.setExecutorManager((ExecutorManagerAdapter)this.executorManager);
            CreateTriggerAction.setTriggerManager((TriggerManager)this.triggerManager);
            ExecutionChecker.setExecutorManager((ExecutorManagerAdapter)this.executorManager);
        }
        this.triggerManager.registerCheckerType("BasicTimeChecker", BasicTimeChecker.class);
        this.triggerManager.registerCheckerType("SlaChecker", SlaChecker.class);
        this.triggerManager.registerCheckerType("ExecutionChecker", ExecutionChecker.class);
        this.triggerManager.registerActionType("ExecuteFlowAction", ExecuteFlowAction.class);
        this.triggerManager.registerActionType("KillExecutionAction", KillExecutionAction.class);
        this.triggerManager.registerActionType("AlertAction", SlaAlertAction.class);
        this.triggerManager.registerActionType("CreateTriggerAction", CreateTriggerAction.class);
    }

    private Map<String, Alerter> loadAlerters(Props props) {
        HashMap<String, Alerter> allAlerters = new HashMap<String, Alerter>();
        Emailer mailAlerter = new Emailer(props);
        allAlerters.put("email", (Alerter)mailAlerter);
        String pluginDir = props.getString("alerter.plugin.dir", "plugins/alerter");
        allAlerters.putAll(this.loadPluginAlerters(pluginDir));
        return allAlerters;
    }

    private Map<String, Alerter> loadPluginAlerters(String pluginPath) {
        File alerterPluginPath = new File(pluginPath);
        if (!alerterPluginPath.exists()) {
            return Collections.emptyMap();
        }
        HashMap<String, Alerter> installedAlerterPlugins = new HashMap<String, Alerter>();
        ClassLoader parentLoader = this.getClass().getClassLoader();
        File[] pluginDirs = alerterPluginPath.listFiles();
        ArrayList<String> jarPaths = new ArrayList<String>();
        File[] fileArray = pluginDirs;
        int n = pluginDirs.length;
        int n2 = 0;
        while (n2 < n) {
            block21: {
                Props pluginProps;
                File propertiesDir;
                File pluginDir;
                block25: {
                    block23: {
                        File propertiesFile;
                        block24: {
                            block22: {
                                pluginDir = fileArray[n2];
                                if (pluginDir.isDirectory()) break block22;
                                logger.error((Object)("The plugin path " + pluginDir + " is not a directory."));
                                break block21;
                            }
                            propertiesDir = new File(pluginDir, "conf");
                            pluginProps = null;
                            if (!propertiesDir.exists() || !propertiesDir.isDirectory()) break block23;
                            propertiesFile = new File(propertiesDir, "plugin.properties");
                            File propertiesOverrideFile = new File(propertiesDir, "override.properties");
                            if (!propertiesFile.exists()) break block24;
                            pluginProps = propertiesOverrideFile.exists() ? PropsUtils.loadProps(null, (File[])new File[]{propertiesFile, propertiesOverrideFile}) : PropsUtils.loadProps(null, (File[])new File[]{propertiesFile});
                            break block25;
                        }
                        logger.error((Object)("Plugin conf file " + propertiesFile + " not found."));
                        break block21;
                    }
                    logger.error((Object)("Plugin conf path " + propertiesDir + " not found."));
                    break block21;
                }
                String pluginName = pluginProps.getString("alerter.name");
                List extLibClasspath = pluginProps.getStringList("alerter.external.classpaths", null);
                String pluginClass = pluginProps.getString("alerter.class");
                if (pluginClass == null) {
                    logger.error((Object)"Alerter class is not set.");
                } else {
                    logger.info((Object)("Plugin class " + pluginClass));
                }
                URLClassLoader urlClassLoader = null;
                File libDir = new File(pluginDir, "lib");
                if (!libDir.exists() || !libDir.isDirectory()) {
                    logger.error((Object)("Library path " + propertiesDir + " not found."));
                } else {
                    File[] files = libDir.listFiles();
                    ArrayList<URL> urls = new ArrayList<URL>();
                    int i = 0;
                    while (i < files.length) {
                        try {
                            URL url = files[i].toURI().toURL();
                            urls.add(url);
                        }
                        catch (MalformedURLException e) {
                            logger.error((Object)e);
                        }
                        ++i;
                    }
                    if (extLibClasspath != null) {
                        for (String extLib : extLibClasspath) {
                            try {
                                File file = new File(pluginDir, extLib);
                                URL url = file.toURI().toURL();
                                urls.add(url);
                            }
                            catch (MalformedURLException e) {
                                logger.error((Object)e);
                            }
                        }
                    }
                    urlClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), parentLoader);
                    Class<?> alerterClass = null;
                    try {
                        alerterClass = urlClassLoader.loadClass(pluginClass);
                    }
                    catch (ClassNotFoundException e) {
                        logger.error((Object)("Class " + pluginClass + " not found."));
                        break block21;
                    }
                    String source = FileIOUtils.getSourcePathFromClass(alerterClass);
                    logger.info((Object)("Source jar " + source));
                    jarPaths.add("jar:file:" + source);
                    Constructor<?> constructor = null;
                    try {
                        constructor = alerterClass.getConstructor(Props.class);
                    }
                    catch (NoSuchMethodException e) {
                        logger.error((Object)("Constructor not found in " + pluginClass));
                        break block21;
                    }
                    Object obj = null;
                    try {
                        obj = constructor.newInstance(pluginProps);
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                    if (!(obj instanceof Alerter)) {
                        logger.error((Object)"The object is not an Alerter");
                    } else {
                        Alerter plugin = obj;
                        installedAlerterPlugins.put(pluginName, plugin);
                    }
                }
            }
            ++n2;
        }
        return installedAlerterPlugins;
    }

    private void loadPluginCheckersAndActions(String pluginPath) {
        logger.info((Object)"Loading plug-in checker and action types");
        File triggerPluginPath = new File(pluginPath);
        if (!triggerPluginPath.exists()) {
            logger.error((Object)("plugin path " + pluginPath + " doesn't exist!"));
            return;
        }
        ClassLoader parentLoader = this.getClassLoader();
        File[] pluginDirs = triggerPluginPath.listFiles();
        ArrayList<String> jarPaths = new ArrayList<String>();
        File[] fileArray = pluginDirs;
        int n = pluginDirs.length;
        int n2 = 0;
        while (n2 < n) {
            block19: {
                Props pluginProps;
                File propertiesDir;
                File pluginDir;
                block24: {
                    block22: {
                        File propertiesFile;
                        block23: {
                            block21: {
                                block20: {
                                    pluginDir = fileArray[n2];
                                    if (pluginDir.exists()) break block20;
                                    logger.error((Object)("Error! Trigger plugin path " + pluginDir.getPath() + " doesn't exist."));
                                    break block19;
                                }
                                if (pluginDir.isDirectory()) break block21;
                                logger.error((Object)("The plugin path " + pluginDir + " is not a directory."));
                                break block19;
                            }
                            propertiesDir = new File(pluginDir, "conf");
                            pluginProps = null;
                            if (!propertiesDir.exists() || !propertiesDir.isDirectory()) break block22;
                            propertiesFile = new File(propertiesDir, "plugin.properties");
                            File propertiesOverrideFile = new File(propertiesDir, "override.properties");
                            if (!propertiesFile.exists()) break block23;
                            pluginProps = propertiesOverrideFile.exists() ? PropsUtils.loadProps(null, (File[])new File[]{propertiesFile, propertiesOverrideFile}) : PropsUtils.loadProps(null, (File[])new File[]{propertiesFile});
                            break block24;
                        }
                        logger.error((Object)("Plugin conf file " + propertiesFile + " not found."));
                        break block19;
                    }
                    logger.error((Object)("Plugin conf path " + propertiesDir + " not found."));
                    break block19;
                }
                List extLibClasspath = pluginProps.getStringList("trigger.external.classpaths", null);
                String pluginClass = pluginProps.getString("trigger.class");
                if (pluginClass == null) {
                    logger.error((Object)"Trigger class is not set.");
                } else {
                    logger.error((Object)("Plugin class " + pluginClass));
                }
                URLClassLoader urlClassLoader = null;
                File libDir = new File(pluginDir, "lib");
                if (!libDir.exists() || !libDir.isDirectory()) {
                    logger.error((Object)("Library path " + propertiesDir + " not found."));
                } else {
                    File[] files = libDir.listFiles();
                    ArrayList<URL> urls = new ArrayList<URL>();
                    int i = 0;
                    while (i < files.length) {
                        try {
                            URL url = files[i].toURI().toURL();
                            urls.add(url);
                        }
                        catch (MalformedURLException e) {
                            logger.error((Object)e);
                        }
                        ++i;
                    }
                    if (extLibClasspath != null) {
                        for (String extLib : extLibClasspath) {
                            try {
                                File file = new File(pluginDir, extLib);
                                URL url = file.toURI().toURL();
                                urls.add(url);
                            }
                            catch (MalformedURLException e) {
                                logger.error((Object)e);
                            }
                        }
                    }
                    urlClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), parentLoader);
                    Class<?> triggerClass = null;
                    try {
                        triggerClass = urlClassLoader.loadClass(pluginClass);
                    }
                    catch (ClassNotFoundException e) {
                        logger.error((Object)("Class " + pluginClass + " not found."));
                        break block19;
                    }
                    String source = FileIOUtils.getSourcePathFromClass(triggerClass);
                    logger.info((Object)("Source jar " + source));
                    jarPaths.add("jar:file:" + source);
                    try {
                        Utils.invokeStaticMethod((ClassLoader)urlClassLoader, (String)pluginClass, (String)"initiateCheckerTypes", (Object[])new Object[]{pluginProps, app});
                    }
                    catch (Exception e) {
                        logger.error((Object)("Unable to initiate checker types for " + pluginClass));
                        break block19;
                    }
                    try {
                        Utils.invokeStaticMethod((ClassLoader)urlClassLoader, (String)pluginClass, (String)"initiateActionTypes", (Object[])new Object[]{pluginProps, app});
                    }
                    catch (Exception e) {
                        logger.error((Object)("Unable to initiate action types for " + pluginClass));
                    }
                }
            }
            ++n2;
        }
    }

    public SessionCache getSessionCache() {
        return this.sessionCache;
    }

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public ProjectManager getProjectManager() {
        return this.projectManager;
    }

    public ExecutorManager getExecutorManager() {
        return this.executorManager;
    }

    public ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }

    public TriggerManager getTriggerManager() {
        return this.triggerManager;
    }

    private VelocityEngine configureVelocityEngine(boolean devMode) {
        VelocityEngine engine = new VelocityEngine();
        engine.setProperty("resource.loader", (Object)"classpath, jar");
        engine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        engine.setProperty("classpath.resource.loader.cache", (Object)(!devMode ? 1 : 0));
        engine.setProperty("classpath.resource.loader.modificationCheckInterval", (Object)5L);
        engine.setProperty("jar.resource.loader.class", (Object)JarResourceLoader.class.getName());
        engine.setProperty("jar.resource.loader.cache", (Object)(!devMode ? 1 : 0));
        engine.setProperty("resource.manager.logwhenfound", (Object)false);
        engine.setProperty("input.encoding", (Object)"UTF-8");
        engine.setProperty("output.encoding", (Object)"UTF-8");
        engine.setProperty("directive.set.null.allowed", (Object)true);
        engine.setProperty("resource.manager.logwhenfound", (Object)false);
        engine.setProperty("velocimacro.permissions.allow.inline", (Object)true);
        engine.setProperty("velocimacro.library.autoreload", (Object)devMode);
        engine.setProperty("velocimacro.library", (Object)"/azkaban/webapp/servlet/velocity/macros.vm");
        engine.setProperty("velocimacro.permissions.allow.inline.to.replace.global", (Object)true);
        engine.setProperty("velocimacro.arguments.strict", (Object)true);
        engine.setProperty("runtime.log.invalid.references", (Object)devMode);
        engine.setProperty("runtime.log.logsystem.class", Log4JLogChute.class);
        engine.setProperty("runtime.log.logsystem.log4j.logger", (Object)Logger.getLogger((String)"org.apache.velocity.Logger"));
        engine.setProperty("parser.pool.size", (Object)3);
        return engine;
    }

    public ClassLoader getClassLoader() {
        return this.baseClassLoader;
    }

    public Props getServerProps() {
        return this.props;
    }

    public static void main(String[] args) throws Exception {
        boolean ssl;
        int port;
        logger.error((Object)"Starting Jetty Azkaban Executor...");
        Props azkabanSettings = AzkabanServer.loadProps((String[])args);
        if (azkabanSettings == null) {
            logger.error((Object)"Azkaban Properties not loaded.");
            logger.error((Object)"Exiting Azkaban...");
            return;
        }
        int maxThreads = azkabanSettings.getInt("jetty.maxThreads", 20);
        Server server = new Server();
        if (azkabanSettings.getBoolean("jetty.use.ssl", true)) {
            int sslPortNumber;
            port = sslPortNumber = azkabanSettings.getInt("jetty.ssl.port", 8443);
            ssl = true;
            logger.info((Object)("Setting up Jetty Https Server with port:" + sslPortNumber + " and numThreads:" + maxThreads));
            SslSocketConnector secureConnector = new SslSocketConnector();
            secureConnector.setPort(sslPortNumber);
            secureConnector.setKeystore(azkabanSettings.getString("jetty.keystore"));
            secureConnector.setPassword(azkabanSettings.getString("jetty.password"));
            secureConnector.setKeyPassword(azkabanSettings.getString("jetty.keypassword"));
            secureConnector.setTruststore(azkabanSettings.getString("jetty.truststore"));
            secureConnector.setTrustPassword(azkabanSettings.getString("jetty.trustpassword"));
            secureConnector.setHeaderBufferSize(0xA00000);
            server.addConnector((Connector)secureConnector);
        } else {
            ssl = false;
            port = azkabanSettings.getInt("jetty.port", 8081);
            SocketConnector connector = new SocketConnector();
            connector.setPort(port);
            connector.setHeaderBufferSize(0xA00000);
            server.addConnector((Connector)connector);
        }
        String hostname = azkabanSettings.getString("jetty.hostname", "localhost");
        azkabanSettings.put("server.hostname", hostname);
        azkabanSettings.put("server.port", Integer.valueOf(port));
        azkabanSettings.put("server.useSSL", String.valueOf(ssl));
        app = new AzkabanWebServer(server, azkabanSettings);
        boolean checkDB = azkabanSettings.getBoolean("database.check.version", false);
        if (checkDB) {
            AzkabanDatabaseSetup setup = new AzkabanDatabaseSetup(azkabanSettings);
            setup.loadTableInfo();
            if (setup.needsUpdating()) {
                logger.error((Object)"Database is out of date.");
                setup.printUpgradePlan();
                logger.error((Object)"Exiting with error.");
                System.exit(-1);
            }
        }
        QueuedThreadPool httpThreadPool = new QueuedThreadPool(maxThreads);
        server.setThreadPool((ThreadPool)httpThreadPool);
        String staticDir = azkabanSettings.getString("web.resource.dir", "");
        logger.info((Object)("Setting up web resource dir " + staticDir));
        Context root = new Context((HandlerContainer)server, "/", 1);
        root.setMaxFormContentSize(0xA00000);
        String defaultServletPath = azkabanSettings.getString("azkaban.default.servlet.path", "/index");
        root.setResourceBase(staticDir);
        ServletHolder indexRedirect = new ServletHolder((Servlet)new IndexRedirectServlet(defaultServletPath));
        root.addServlet(indexRedirect, "/");
        ServletHolder index = new ServletHolder((Servlet)new ProjectServlet());
        root.addServlet(index, "/index");
        ServletHolder staticServlet = new ServletHolder((Servlet)new DefaultServlet());
        root.addServlet(staticServlet, "/css/*");
        root.addServlet(staticServlet, "/js/*");
        root.addServlet(staticServlet, "/images/*");
        root.addServlet(staticServlet, "/fonts/*");
        root.addServlet(staticServlet, "/favicon.ico");
        root.addServlet(new ServletHolder((Servlet)new ProjectManagerServlet()), "/manager");
        root.addServlet(new ServletHolder((Servlet)new ExecutorServlet()), "/executor");
        root.addServlet(new ServletHolder((Servlet)new HistoryServlet()), "/history");
        root.addServlet(new ServletHolder((Servlet)new ScheduleServlet()), "/schedule");
        root.addServlet(new ServletHolder((Servlet)new JMXHttpServlet()), "/jmx");
        root.addServlet(new ServletHolder((Servlet)new TriggerManagerServlet()), "/triggers");
        ServletHolder restliHolder = new ServletHolder((Servlet)new RestliServlet());
        restliHolder.setInitParameter("resourcePackages", "azkaban.restli");
        root.addServlet(restliHolder, "/restli/*");
        String viewerPluginDir = azkabanSettings.getString("viewer.plugin.dir", "plugins/viewer");
        AzkabanWebServer.loadViewerPlugins((Context)root, (String)viewerPluginDir, (VelocityEngine)app.getVelocityEngine());
        String triggerPluginDir = azkabanSettings.getString("trigger.plugin.dir", "plugins/triggers");
        Map triggerPlugins = AzkabanWebServer.loadTriggerPlugins((Context)root, (String)triggerPluginDir, (AzkabanWebServer)app);
        app.setTriggerPlugins(triggerPlugins);
        app.getTriggerManager().start();
        root.setAttribute("azkaban_app", (Object)app);
        try {
            server.start();
        }
        catch (Exception e) {
            logger.warn((Object)e);
            Utils.croak((String)e.getMessage(), (int)1);
        }
        Runtime.getRuntime().addShutdownHook((Thread)new /* Unavailable Anonymous Inner Class!! */);
        logger.info((Object)("Server running on " + (ssl ? "ssl" : "") + " port " + port + "."));
    }

    private static Map<String, TriggerPlugin> loadTriggerPlugins(Context root, String pluginPath, AzkabanWebServer azkabanWebApp) {
        File triggerPluginPath = new File(pluginPath);
        if (!triggerPluginPath.exists()) {
            return new HashMap<String, TriggerPlugin>();
        }
        HashMap<String, TriggerPlugin> installedTriggerPlugins = new HashMap<String, TriggerPlugin>();
        ClassLoader parentLoader = AzkabanWebServer.class.getClassLoader();
        File[] pluginDirs = triggerPluginPath.listFiles();
        ArrayList<String> jarPaths = new ArrayList<String>();
        File[] fileArray = pluginDirs;
        int n = pluginDirs.length;
        int n2 = 0;
        while (n2 < n) {
            block21: {
                Props pluginProps;
                File propertiesDir;
                File pluginDir;
                block26: {
                    block24: {
                        File propertiesFile;
                        block25: {
                            block23: {
                                block22: {
                                    pluginDir = fileArray[n2];
                                    if (pluginDir.exists()) break block22;
                                    logger.error((Object)("Error! Trigger plugin path " + pluginDir.getPath() + " doesn't exist."));
                                    break block21;
                                }
                                if (pluginDir.isDirectory()) break block23;
                                logger.error((Object)("The plugin path " + pluginDir + " is not a directory."));
                                break block21;
                            }
                            propertiesDir = new File(pluginDir, "conf");
                            pluginProps = null;
                            if (!propertiesDir.exists() || !propertiesDir.isDirectory()) break block24;
                            propertiesFile = new File(propertiesDir, "plugin.properties");
                            File propertiesOverrideFile = new File(propertiesDir, "override.properties");
                            if (!propertiesFile.exists()) break block25;
                            pluginProps = propertiesOverrideFile.exists() ? PropsUtils.loadProps(null, (File[])new File[]{propertiesFile, propertiesOverrideFile}) : PropsUtils.loadProps(null, (File[])new File[]{propertiesFile});
                            break block26;
                        }
                        logger.error((Object)("Plugin conf file " + propertiesFile + " not found."));
                        break block21;
                    }
                    logger.error((Object)("Plugin conf path " + propertiesDir + " not found."));
                    break block21;
                }
                String pluginName = pluginProps.getString("trigger.name");
                List extLibClasspath = pluginProps.getStringList("trigger.external.classpaths", null);
                String pluginClass = pluginProps.getString("trigger.class");
                if (pluginClass == null) {
                    logger.error((Object)"Trigger class is not set.");
                } else {
                    logger.error((Object)("Plugin class " + pluginClass));
                }
                URLClassLoader urlClassLoader = null;
                File libDir = new File(pluginDir, "lib");
                if (!libDir.exists() || !libDir.isDirectory()) {
                    logger.error((Object)("Library path " + propertiesDir + " not found."));
                } else {
                    File[] files = libDir.listFiles();
                    ArrayList<URL> urls = new ArrayList<URL>();
                    int i = 0;
                    while (i < files.length) {
                        try {
                            URL url = files[i].toURI().toURL();
                            urls.add(url);
                        }
                        catch (MalformedURLException e) {
                            logger.error((Object)e);
                        }
                        ++i;
                    }
                    if (extLibClasspath != null) {
                        for (String extLib : extLibClasspath) {
                            try {
                                File file = new File(pluginDir, extLib);
                                URL url = file.toURI().toURL();
                                urls.add(url);
                            }
                            catch (MalformedURLException e) {
                                logger.error((Object)e);
                            }
                        }
                    }
                    urlClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), parentLoader);
                    Class<?> triggerClass = null;
                    try {
                        triggerClass = urlClassLoader.loadClass(pluginClass);
                    }
                    catch (ClassNotFoundException e) {
                        logger.error((Object)("Class " + pluginClass + " not found."));
                        break block21;
                    }
                    String source = FileIOUtils.getSourcePathFromClass(triggerClass);
                    logger.info((Object)("Source jar " + source));
                    jarPaths.add("jar:file:" + source);
                    Constructor<?> constructor = null;
                    try {
                        constructor = triggerClass.getConstructor(String.class, Props.class, Context.class, AzkabanWebServer.class);
                    }
                    catch (NoSuchMethodException e) {
                        logger.error((Object)("Constructor not found in " + pluginClass));
                        break block21;
                    }
                    Object obj = null;
                    try {
                        obj = constructor.newInstance(pluginName, pluginProps, root, azkabanWebApp);
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                    if (!(obj instanceof TriggerPlugin)) {
                        logger.error((Object)"The object is not an TriggerPlugin");
                    } else {
                        TriggerPlugin plugin = obj;
                        installedTriggerPlugins.put(pluginName, plugin);
                    }
                }
            }
            ++n2;
        }
        String jarResourcePath = StringUtils.join(jarPaths, (String)", ");
        logger.info((Object)("Setting jar resource path " + jarResourcePath));
        VelocityEngine ve = azkabanWebApp.getVelocityEngine();
        ve.addProperty("jar.resource.loader.path", (Object)jarResourcePath);
        return installedTriggerPlugins;
    }

    public Map<String, TriggerPlugin> getTriggerPlugins() {
        return this.triggerPlugins;
    }

    private static void loadViewerPlugins(Context root, String pluginPath, VelocityEngine ve) {
        File viewerPluginPath = new File(pluginPath);
        if (!viewerPluginPath.exists()) {
            return;
        }
        ClassLoader parentLoader = AzkabanWebServer.class.getClassLoader();
        File[] pluginDirs = viewerPluginPath.listFiles();
        ArrayList<String> jarPaths = new ArrayList<String>();
        File[] fileArray = pluginDirs;
        int n = pluginDirs.length;
        int n2 = 0;
        while (n2 < n) {
            block26: {
                Props pluginProps;
                File pluginDir;
                block31: {
                    File propertiesDir;
                    block29: {
                        File propertiesFile;
                        block30: {
                            block28: {
                                block27: {
                                    pluginDir = fileArray[n2];
                                    if (pluginDir.exists()) break block27;
                                    logger.error((Object)("Error viewer plugin path " + pluginDir.getPath() + " doesn't exist."));
                                    break block26;
                                }
                                if (pluginDir.isDirectory()) break block28;
                                logger.error((Object)("The plugin path " + pluginDir + " is not a directory."));
                                break block26;
                            }
                            propertiesDir = new File(pluginDir, "conf");
                            pluginProps = null;
                            if (!propertiesDir.exists() || !propertiesDir.isDirectory()) break block29;
                            propertiesFile = new File(propertiesDir, "plugin.properties");
                            File propertiesOverrideFile = new File(propertiesDir, "override.properties");
                            if (!propertiesFile.exists()) break block30;
                            pluginProps = propertiesOverrideFile.exists() ? PropsUtils.loadProps(null, (File[])new File[]{propertiesFile, propertiesOverrideFile}) : PropsUtils.loadProps(null, (File[])new File[]{propertiesFile});
                            break block31;
                        }
                        logger.error((Object)("Plugin conf file " + propertiesFile + " not found."));
                        break block26;
                    }
                    logger.error((Object)("Plugin conf path " + propertiesDir + " not found."));
                    break block26;
                }
                String pluginName = pluginProps.getString("viewer.name");
                String pluginWebPath = pluginProps.getString("viewer.path");
                String pluginJobTypes = pluginProps.getString("viewer.jobtypes", null);
                int pluginOrder = pluginProps.getInt("viewer.order", 0);
                boolean pluginHidden = pluginProps.getBoolean("viewer.hidden", false);
                List extLibClasspath = pluginProps.getStringList("viewer.external.classpaths", null);
                String pluginClass = pluginProps.getString("viewer.servlet.class");
                if (pluginClass == null) {
                    logger.error((Object)"Viewer class is not set.");
                } else {
                    logger.error((Object)("Plugin class " + pluginClass));
                }
                URLClassLoader urlClassLoader = null;
                File libDir = new File(pluginDir, "lib");
                if (!libDir.exists() || !libDir.isDirectory()) {
                    logger.error((Object)("Library path " + libDir.getAbsolutePath() + " not found."));
                } else {
                    File[] files = libDir.listFiles();
                    ArrayList<URL> urls = new ArrayList<URL>();
                    int i = 0;
                    while (i < files.length) {
                        try {
                            URL url = files[i].toURI().toURL();
                            urls.add(url);
                        }
                        catch (MalformedURLException e) {
                            logger.error((Object)e);
                        }
                        ++i;
                    }
                    if (extLibClasspath != null) {
                        for (String extLib : extLibClasspath) {
                            File extLibFile = new File(pluginDir, extLib);
                            if (extLibFile.exists()) {
                                if (extLibFile.isDirectory()) {
                                    File[] extLibFiles = extLibFile.listFiles();
                                    int i2 = 0;
                                    while (i2 < extLibFiles.length) {
                                        try {
                                            URL url = extLibFiles[i2].toURI().toURL();
                                            urls.add(url);
                                        }
                                        catch (MalformedURLException e) {
                                            logger.error((Object)e);
                                        }
                                        ++i2;
                                    }
                                    continue;
                                }
                                try {
                                    URL url = extLibFile.toURI().toURL();
                                    urls.add(url);
                                }
                                catch (MalformedURLException e) {
                                    logger.error((Object)e);
                                }
                                continue;
                            }
                            logger.error((Object)("External library path " + extLibFile.getAbsolutePath() + " not found."));
                        }
                    }
                    urlClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), parentLoader);
                    Class<?> viewerClass = null;
                    try {
                        viewerClass = urlClassLoader.loadClass(pluginClass);
                    }
                    catch (ClassNotFoundException e) {
                        logger.error((Object)("Class " + pluginClass + " not found."));
                        break block26;
                    }
                    String source = FileIOUtils.getSourcePathFromClass(viewerClass);
                    logger.info((Object)("Source jar " + source));
                    jarPaths.add("jar:file:" + source);
                    Constructor<?> constructor = null;
                    try {
                        constructor = viewerClass.getConstructor(Props.class);
                    }
                    catch (NoSuchMethodException e) {
                        logger.error((Object)("Constructor not found in " + pluginClass));
                        break block26;
                    }
                    Object obj = null;
                    try {
                        obj = constructor.newInstance(pluginProps);
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                        logger.error((Object)e.getCause());
                    }
                    if (!(obj instanceof AbstractAzkabanServlet)) {
                        logger.error((Object)"The object is not an AbstractAzkabanServlet");
                    } else {
                        AbstractAzkabanServlet avServlet = obj;
                        root.addServlet(new ServletHolder((Servlet)avServlet), "/" + pluginWebPath + "/*");
                        PluginRegistry.getRegistry().register(new ViewerPlugin(pluginName, pluginWebPath, pluginOrder, pluginHidden, pluginJobTypes));
                    }
                }
            }
            ++n2;
        }
        String jarResourcePath = StringUtils.join(jarPaths, (String)", ");
        logger.info((Object)("Setting jar resource path " + jarResourcePath));
        ve.addProperty("jar.resource.loader.path", (Object)jarResourcePath);
    }

    private static Props loadConfigurationFromAzkabanHome() {
        String azkabanHome = System.getenv("AZKABAN_HOME");
        if (azkabanHome == null) {
            logger.error((Object)"AZKABAN_HOME not set. Will try default.");
            return null;
        }
        if (!new File(azkabanHome).isDirectory() || !new File(azkabanHome).canRead()) {
            logger.error((Object)(String.valueOf(azkabanHome) + " is not a readable directory."));
            return null;
        }
        File confPath = new File(azkabanHome, "conf");
        if (!(confPath.exists() && confPath.isDirectory() && confPath.canRead())) {
            logger.error((Object)(String.valueOf(azkabanHome) + " does not contain a readable conf directory."));
            return null;
        }
        return AzkabanWebServer.loadAzkabanConfigurationFromDirectory((File)confPath);
    }

    public File getTempDirectory() {
        return this.tempDir;
    }

    private static Props loadAzkabanConfigurationFromDirectory(File dir) {
        File azkabanPrivatePropsFile = new File(dir, "azkaban.private.properties");
        File azkabanPropsFile = new File(dir, "azkaban.properties");
        Props props = null;
        try {
            if (azkabanPrivatePropsFile.exists() && azkabanPrivatePropsFile.isFile()) {
                logger.info((Object)"Loading azkaban private properties file");
                props = new Props(null, azkabanPrivatePropsFile);
            }
            if (azkabanPropsFile.exists() && azkabanPropsFile.isFile()) {
                logger.info((Object)"Loading azkaban properties file");
                props = new Props(props, azkabanPropsFile);
            }
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"File not found. Could not load azkaban config file", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"File found, but error reading. Could not load azkaban config file", (Throwable)e);
        }
        return props;
    }

    private void configureMBeanServer() {
        logger.info((Object)"Registering MBeans...");
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        this.registerMbean("jetty", (Object)new JmxJettyServer(this.server));
        this.registerMbean("triggerManager", (Object)new JmxTriggerManager((TriggerManagerAdapter)this.triggerManager));
        if (this.executorManager instanceof ExecutorManager) {
            this.registerMbean("executorManager", (Object)new JmxExecutorManager(this.executorManager));
        }
    }

    public void close() {
        try {
            for (ObjectName name : this.registeredMBeans) {
                this.mbeanServer.unregisterMBean(name);
                logger.info((Object)("Jmx MBean " + name.getCanonicalName() + " unregistered."));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to cleanup MBeanServer", (Throwable)e);
        }
        this.scheduleManager.shutdown();
        this.executorManager.shutdown();
    }

    private void registerMbean(String name, Object mbean) {
        Class<?> mbeanClass = mbean.getClass();
        try {
            ObjectName mbeanName = new ObjectName(String.valueOf(mbeanClass.getName()) + ":name=" + name);
            this.mbeanServer.registerMBean(mbean, mbeanName);
            logger.info((Object)("Bean " + mbeanClass.getCanonicalName() + " registered."));
            this.registeredMBeans.add(mbeanName);
        }
        catch (Exception e) {
            logger.error((Object)("Error registering mbean " + mbeanClass.getCanonicalName()), (Throwable)e);
        }
    }

    public List<ObjectName> getMbeanNames() {
        return this.registeredMBeans;
    }

    public MBeanInfo getMBeanInfo(ObjectName name) {
        try {
            return this.mbeanServer.getMBeanInfo(name);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public Object getMBeanAttribute(ObjectName name, String attribute) {
        try {
            return this.mbeanServer.getAttribute(name, attribute);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    static /* synthetic */ Logger access$0() {
        return logger;
    }

    static /* synthetic */ AzkabanWebServer access$1() {
        return app;
    }
}

