/*
 * Decompiled with CFR 0.152.
 */
package azkaban.trigger.builtin;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutorManagerAdapter;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.Status;
import azkaban.trigger.ConditionChecker;
import java.util.HashMap;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExecutionChecker
implements ConditionChecker {
    public static final String type = "ExecutionChecker";
    public static ExecutorManagerAdapter executorManager;
    private String checkerId;
    private int execId;
    private String jobName;
    private Status wantedStatus;

    public ExecutionChecker(String checkerId, int execId, String jobName, Status wantedStatus) {
        this.checkerId = checkerId;
        this.execId = execId;
        this.jobName = jobName;
        this.wantedStatus = wantedStatus;
    }

    public static void setExecutorManager(ExecutorManagerAdapter em) {
        executorManager = em;
    }

    public Object eval() {
        ExecutableFlow exflow;
        try {
            exflow = executorManager.getExecutableFlow(this.execId);
        }
        catch (ExecutorManagerException e) {
            e.printStackTrace();
            return Boolean.FALSE;
        }
        if (this.jobName != null) {
            ExecutableNode job = exflow.getExecutableNode(this.jobName);
            if (job != null) {
                return job.getStatus().equals((Object)this.wantedStatus);
            }
            return Boolean.FALSE;
        }
        return exflow.getStatus().equals((Object)this.wantedStatus);
    }

    public Object getNum() {
        return null;
    }

    public void reset() {
    }

    public String getId() {
        return this.checkerId;
    }

    public String getType() {
        return "ExecutionChecker";
    }

    public static ExecutionChecker createFromJson(HashMap<String, Object> jsonObj) throws Exception {
        if (!jsonObj.get("type").equals("ExecutionChecker")) {
            throw new Exception("Cannot create checker of ExecutionChecker from " + jsonObj.get("type"));
        }
        int execId = Integer.valueOf((String)jsonObj.get("execId"));
        String jobName = null;
        if (jsonObj.containsKey("jobName")) {
            jobName = (String)jsonObj.get("jobName");
        }
        String checkerId = (String)jsonObj.get("checkerId");
        Status wantedStatus = Status.valueOf((String)((String)jsonObj.get("wantedStatus")));
        return new ExecutionChecker(checkerId, execId, jobName, wantedStatus);
    }

    public ConditionChecker fromJson(Object obj) throws Exception {
        return ExecutionChecker.createFromJson((HashMap)((HashMap)obj));
    }

    public Object toJson() {
        HashMap<String, String> jsonObj = new HashMap<String, String>();
        jsonObj.put("type", "ExecutionChecker");
        jsonObj.put("execId", String.valueOf(this.execId));
        if (this.jobName != null) {
            jsonObj.put("jobName", this.jobName);
        }
        jsonObj.put("wantedStatus", this.wantedStatus.toString());
        jsonObj.put("checkerId", this.checkerId);
        return jsonObj;
    }

    public void stopChecker() {
    }

    public void setContext(Map<String, Object> context) {
    }

    public long getNextCheckTime() {
        return -1L;
    }
}

