/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import azkaban.executor.ExecutableFlowBase;
import azkaban.utils.JSONUtils;
import azkaban.utils.Props;
import azkaban.utils.UndefinedPropertyException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;

/*
 * Exception performing whole class analysis ignored.
 */
public class PropsUtils {
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\{([a-zA-Z_.0-9]+)\\}");

    public static Props loadPropsInDir(File dir, String ... suffixes) {
        return PropsUtils.loadPropsInDir(null, (File)dir, (String[])suffixes);
    }

    public static Props loadPropsInDir(Props parent, File dir, String ... suffixes) {
        try {
            Props props = new Props(parent);
            Object[] files = dir.listFiles();
            Arrays.sort(files);
            if (files != null) {
                Object[] objectArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    Object f = objectArray[n2];
                    if (((File)f).isFile() && PropsUtils.endsWith((File)f, (String[])suffixes)) {
                        props.putAll(new Props(null, ((File)f).getAbsolutePath()));
                    }
                    ++n2;
                }
            }
            return props;
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading properties.", e);
        }
    }

    public static Props loadProps(Props parent, File ... propFiles) {
        try {
            Props props = new Props(parent);
            File[] fileArray = propFiles;
            int n = propFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isFile()) {
                    props = new Props(props, f);
                }
                ++n2;
            }
            return props;
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading properties.", e);
        }
    }

    public static Props loadPropsInDirs(List<File> dirs, String ... suffixes) {
        Props props = new Props();
        for (File dir : dirs) {
            props.putLocal(PropsUtils.loadPropsInDir((File)dir, (String[])suffixes));
        }
        return props;
    }

    public static void loadPropsBySuffix(File jobPath, Props props, String ... suffixes) {
        try {
            if (jobPath.isDirectory()) {
                File[] files = jobPath.listFiles();
                if (files != null) {
                    File[] fileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        PropsUtils.loadPropsBySuffix((File)file, (Props)props, (String[])suffixes);
                        ++n2;
                    }
                }
            } else if (PropsUtils.endsWith((File)jobPath, (String[])suffixes)) {
                props.putAll(new Props(null, jobPath.getAbsolutePath()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading schedule properties.", e);
        }
    }

    public static boolean endsWith(File file, String ... suffixes) {
        String[] stringArray = suffixes;
        int n = suffixes.length;
        int n2 = 0;
        while (n2 < n) {
            String suffix = stringArray[n2];
            if (file.getName().endsWith(suffix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Props resolveProps(Props props) {
        if (props == null) {
            return null;
        }
        Props resolvedProps = new Props();
        LinkedHashSet<String> visitedVariables = new LinkedHashSet<String>();
        for (String key : props.getKeySet()) {
            String value = props.get((Object)key);
            visitedVariables.add(key);
            String replacedValue = PropsUtils.resolveVariableReplacement((String)value, (Props)props, visitedVariables);
            visitedVariables.clear();
            resolvedProps.put(key, replacedValue);
        }
        return resolvedProps;
    }

    private static String resolveVariableReplacement(String value, Props props, LinkedHashSet<String> visitedVariables) {
        StringBuffer buffer = new StringBuffer();
        int startIndex = 0;
        Matcher matcher = VARIABLE_PATTERN.matcher(value);
        while (matcher.find(startIndex)) {
            String subVariable;
            if (startIndex < matcher.start()) {
                buffer.append(value.substring(startIndex, matcher.start()));
            }
            if (visitedVariables.contains(subVariable = matcher.group(1))) {
                throw new IllegalArgumentException(String.format("Circular variable substitution found: [%s] -> [%s]", StringUtils.join(visitedVariables, (String)"->"), subVariable));
            }
            String replacement = props.get((Object)subVariable);
            visitedVariables.add(subVariable);
            if (replacement == null) {
                throw new UndefinedPropertyException(String.format("Could not find variable substitution for variable(s) [%s]", StringUtils.join(visitedVariables, (String)"->")));
            }
            buffer.append(PropsUtils.resolveVariableReplacement((String)replacement, (Props)props, visitedVariables));
            visitedVariables.remove(subVariable);
            startIndex = matcher.end();
        }
        if (startIndex < value.length()) {
            buffer.append(value.substring(startIndex));
        }
        return buffer.toString();
    }

    public static Props addCommonFlowProperties(Props parentProps, ExecutableFlowBase flow) {
        Props props = new Props(parentProps);
        props.put("azkaban.flow.flowid", flow.getFlowId());
        props.put("azkaban.flow.execid", Integer.valueOf(flow.getExecutionId()));
        props.put("azkaban.flow.projectid", Integer.valueOf(flow.getProjectId()));
        props.put("azkaban.flow.projectversion", Integer.valueOf(flow.getVersion()));
        props.put("azkaban.flow.uuid", UUID.randomUUID().toString());
        DateTime loadTime = new DateTime();
        props.put("azkaban.flow.start.timestamp", loadTime.toString());
        props.put("azkaban.flow.start.year", loadTime.toString("yyyy"));
        props.put("azkaban.flow.start.month", loadTime.toString("MM"));
        props.put("azkaban.flow.start.day", loadTime.toString("dd"));
        props.put("azkaban.flow.start.hour", loadTime.toString("HH"));
        props.put("azkaban.flow.start.minute", loadTime.toString("mm"));
        props.put("azkaban.flow.start.second", loadTime.toString("ss"));
        props.put("azkaban.flow.start.milliseconds", loadTime.toString("SSS"));
        props.put("azkaban.flow.start.timezone", loadTime.toString("ZZZZ"));
        return props;
    }

    public static String toJSONString(Props props, boolean localOnly) {
        Map map = PropsUtils.toStringMap((Props)props, (boolean)localOnly);
        return JSONUtils.toJSON((Object)map);
    }

    public static Map<String, String> toStringMap(Props props, boolean localOnly) {
        HashMap<String, String> map = new HashMap<String, String>();
        Set keyset = localOnly ? props.localKeySet() : props.getKeySet();
        for (String key : keyset) {
            String value = props.get((Object)key);
            map.put(key, value);
        }
        return map;
    }

    public static Props fromJSONString(String json) {
        try {
            Map obj = (Map)JSONUtils.parseJSONFromString((String)json);
            Props props = new Props(null, new Map[]{obj});
            return props;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Props fromHierarchicalMap(Map<String, Object> propsMap) {
        if (propsMap == null) {
            return null;
        }
        String source = (String)propsMap.get("source");
        Map propsParams = (Map)propsMap.get("props");
        Map parent = (Map)propsMap.get("parent");
        Props parentProps = PropsUtils.fromHierarchicalMap((Map)parent);
        Props props = new Props(parentProps, new Map[]{propsParams});
        props.setSource(source);
        return props;
    }

    public static Map<String, Object> toHierarchicalMap(Props props) {
        HashMap<String, Object> propsMap = new HashMap<String, Object>();
        propsMap.put("source", props.getSource());
        propsMap.put("props", PropsUtils.toStringMap((Props)props, (boolean)true));
        if (props.getParent() != null) {
            propsMap.put("parent", PropsUtils.toHierarchicalMap((Props)props.getParent()));
        }
        return propsMap;
    }
}

