/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;

/*
 * Exception performing whole class analysis ignored.
 */
public class JSONUtils {
    private JSONUtils() {
    }

    public static String toJSON(Object obj) {
        return JSONUtils.toJSON((Object)obj, (boolean)false);
    }

    public static String toJSON(Object obj, boolean prettyPrint) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            if (prettyPrint) {
                ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
                return writer.writeValueAsString(obj);
            }
            return mapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void toJSON(Object obj, OutputStream stream) {
        JSONUtils.toJSON((Object)obj, (OutputStream)stream, (boolean)false);
    }

    public static void toJSON(Object obj, OutputStream stream, boolean prettyPrint) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            if (prettyPrint) {
                ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
                writer.writeValue(stream, obj);
                return;
            }
            mapper.writeValue(stream, obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void toJSON(Object obj, File file) throws IOException {
        JSONUtils.toJSON((Object)obj, (File)file, (boolean)false);
    }

    public static void toJSON(Object obj, File file, boolean prettyPrint) throws IOException {
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            JSONUtils.toJSON((Object)obj, (OutputStream)stream, (boolean)prettyPrint);
        }
        finally {
            stream.close();
        }
    }

    public static Object parseJSONFromStringQuiet(String json) {
        try {
            return JSONUtils.parseJSONFromString((String)json);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object parseJSONFromString(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(json);
        JsonNode node = mapper.readTree(parser);
        return JSONUtils.toObjectFromJSONNode((JsonNode)node);
    }

    public static Object parseJSONFromFile(File file) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(file);
        JsonNode node = mapper.readTree(parser);
        return JSONUtils.toObjectFromJSONNode((JsonNode)node);
    }

    public static Object parseJSONFromReader(Reader reader) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(reader);
        JsonNode node = mapper.readTree(parser);
        return JSONUtils.toObjectFromJSONNode((JsonNode)node);
    }

    private static Object toObjectFromJSONNode(JsonNode node) {
        if (node.isObject()) {
            HashMap<String, Object> obj = new HashMap<String, Object>();
            Iterator iter = node.getFieldNames();
            while (iter.hasNext()) {
                String fieldName = (String)iter.next();
                JsonNode subNode = node.get(fieldName);
                Object subObj = JSONUtils.toObjectFromJSONNode((JsonNode)subNode);
                obj.put(fieldName, subObj);
            }
            return obj;
        }
        if (node.isArray()) {
            ArrayList<Object> array = new ArrayList<Object>();
            Iterator iter = node.getElements();
            while (iter.hasNext()) {
                JsonNode element = (JsonNode)iter.next();
                Object subObject = JSONUtils.toObjectFromJSONNode((JsonNode)element);
                array.add(subObject);
            }
            return array;
        }
        if (node.isTextual()) {
            return node.asText();
        }
        if (node.isNumber()) {
            if (node.isInt()) {
                return node.asInt();
            }
            if (node.isLong()) {
                return node.asLong();
            }
            if (node.isDouble()) {
                return node.asDouble();
            }
            System.err.println("ERROR What is this!? " + node.getNumberType());
            return null;
        }
        if (node.isBoolean()) {
            return node.asBoolean();
        }
        return null;
    }

    public static long getLongFromObject(Object obj) {
        if (obj instanceof Integer) {
            return ((Integer)obj).intValue();
        }
        return (Long)obj;
    }

    public static void writePropsNoJarDependency(Map<String, String> properties, Writer writer) throws IOException {
        writer.write("{\n");
        int size = properties.size();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            writer.write(9);
            writer.write(JSONUtils.quoteAndClean((String)entry.getKey()));
            writer.write(58);
            writer.write(JSONUtils.quoteAndClean((String)entry.getValue()));
            if (--size > 0) {
                writer.write(44);
            }
            writer.write(10);
        }
        writer.write("}");
    }

    private static String quoteAndClean(String str) {
        if (str == null || str.isEmpty()) {
            return "\"\"";
        }
        StringBuffer buffer = new StringBuffer(str.length());
        buffer.append('\"');
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\b': {
                    buffer.append("\\b");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                case '\"': 
                case '/': 
                case '\\': {
                    buffer.append('\\');
                    buffer.append(ch);
                    break;
                }
                default: {
                    if (JSONUtils.isCharSpecialUnicode((char)ch)) {
                        buffer.append("\\u");
                        String hexCode = Integer.toHexString(ch);
                        int lengthHexCode = hexCode.length();
                        if (lengthHexCode < 4) {
                            buffer.append("0000".substring(0, 4 - lengthHexCode));
                        }
                        buffer.append(hexCode);
                        break;
                    }
                    buffer.append(ch);
                }
            }
            ++i;
        }
        buffer.append('\"');
        return buffer.toString();
    }

    private static boolean isCharSpecialUnicode(char ch) {
        if (ch < ' ') {
            return true;
        }
        if (ch >= '\u0080' && ch < '\u00a0') {
            return true;
        }
        return ch >= '\u2000' && ch < '\u2100';
    }
}

