/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.parser.AliasMasker;
import org.apache.pig.parser.ParserException;
import org.apache.pig.parser.PigParserNode;
import org.apache.pig.parser.QueryLexer;
import org.apache.pig.parser.QueryParser;
import org.apache.pig.parser.QueryParserStringStream;
import org.apache.pig.parser.QueryParserUtils;
import org.apache.pig.tools.parameters.ParameterSubstitutionPreprocessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PigMacro {
    private static final Log LOG = LogFactory.getLog(PigMacro.class);
    private String fileName;
    private String name;
    private String body;
    private List<String> params;
    private List<String> rets;
    private Map<String, PigMacro> seen;
    private Set<String> macroStack;
    private long idx = 0L;
    private int startLine = 0;

    PigMacro(String name, String file, List<String> params, List<String> returns, String body, Map<String, PigMacro> seen) {
        this.name = name;
        this.params = params == null ? new ArrayList() : params;
        this.rets = returns == null ? new ArrayList() : returns;
        this.fileName = file;
        this.body = body;
        this.seen = seen;
        this.macroStack = new HashSet<String>();
        LOG.debug((Object)("Macro '" + name + "' is defined"));
    }

    String getName() {
        return this.name;
    }

    void setStack(Set<String> stack) {
        this.macroStack = stack;
    }

    Set<String> getStack() {
        return this.macroStack;
    }

    void setStartLine(int start) {
        this.startLine = start;
    }

    int getStartLine() {
        return this.startLine;
    }

    private CommonTree inline(String[] inputs, String[] outputs, CommonTree t, String file) throws ParserException {
        String in = this.substituteParams(inputs, outputs, t.getLine(), file);
        HashSet<String> masks = new HashSet<String>();
        if (inputs != null) {
            for (String s : inputs) {
                masks.add(s);
            }
        }
        for (String s : outputs) {
            masks.add(s);
        }
        return this.maskAlias(in, masks, t, file);
    }

    private String substituteParams(String[] inputs, String[] outputs, int line, String file) throws ParserException {
        if (inputs == null && !this.params.isEmpty() || inputs != null && inputs.length != this.params.size()) {
            String msg = PigMacro.getErrorMessage(file, line, "Failed to expand macro '" + this.name + "'", "Expected number of parameters: " + this.params.size() + " actual number of inputs: " + (inputs == null ? 0 : inputs.length));
            throw new ParserException(msg);
        }
        boolean isVoidReturn = false;
        if (this.rets.isEmpty()) {
            if (outputs != null && outputs.length > 0) {
                String msg = PigMacro.getErrorMessage(file, line, "Cannot expand macro '" + this.name + "'", "Expected number of return aliases: 0 actual number of return values: " + outputs.length);
                throw new ParserException(msg);
            }
            isVoidReturn = true;
        }
        if (!isVoidReturn && (outputs == null && !this.rets.isEmpty() || outputs != null && outputs.length != this.rets.size())) {
            String msg = PigMacro.getErrorMessage(file, line, "Failed to expand macro '" + this.name + "'", "Expected number of return aliases: " + this.rets.size() + " actual number of return values: " + (outputs == null ? 0 : outputs.length));
            throw new ParserException(msg);
        }
        String[] args = new String[this.params.size()];
        for (int i = 0; i < this.params.size(); ++i) {
            args[i] = this.params.get(i) + "=" + inputs[i];
        }
        if (!isVoidReturn) {
            String[] args1 = new String[this.params.size() + this.rets.size()];
            System.arraycopy(args, 0, args1, 0, this.params.size());
            args = args1;
            for (int i = 0; i < this.rets.size(); ++i) {
                args[this.params.size() + i] = this.rets.get(i) + "=" + outputs[i];
            }
        }
        StringWriter writer = new StringWriter();
        BufferedReader in = new BufferedReader(new StringReader(this.body));
        try {
            ParameterSubstitutionPreprocessor psp = new ParameterSubstitutionPreprocessor(50);
            psp.genSubstitutedFile(in, writer, args, null);
        }
        catch (Exception e) {
            String msg = PigMacro.getErrorMessage(file, line, "Macro inline failed for macro '" + this.name + "'", e.getMessage() + "\n Macro content: " + this.body);
            throw new ParserException(msg);
        }
        LOG.debug((Object)("--- after substition:\n" + writer.toString()));
        return writer.toString();
    }

    private CommonTree maskAlias(String in, Set<String> masks, CommonTree tree, String file) throws ParserException {
        int line = tree.getChild(0).getLine();
        QueryParserStringStream input = null;
        try {
            input = new QueryParserStringStream(in, file);
        }
        catch (IOException e) {
            String msg = PigMacro.getErrorMessage(file, line, "Failed to inline macro '" + this.name + "'", e.getMessage() + "\nmacro content: " + in);
            throw new ParserException(msg);
        }
        QueryLexer lex = new QueryLexer(input);
        CommonTokenStream tokens = new CommonTokenStream(lex);
        QueryParser.query_return result = null;
        QueryParser parser = QueryParserUtils.createParser(tokens, this.startLine - 1);
        try {
            result = parser.query();
        }
        catch (RecognitionException e) {
            String msg = this.fileName == null ? parser.getErrorHeader(e) : QueryParserUtils.generateErrorHeader(e, this.fileName);
            msg = msg + " " + parser.getErrorMessage(e, parser.getTokenNames());
            String msg2 = PigMacro.getErrorMessage(file, line, "Failed to parse macro '" + this.name + "'", msg + "\nmacro content: " + in);
            throw new ParserException(msg2);
        }
        CommonTree ast = (CommonTree)result.getTree();
        LOG.debug((Object)("AST for macro '" + this.name + "':\n" + ast.toStringTree()));
        ArrayList<CommonTree> macroDefNodes = new ArrayList<CommonTree>();
        PigMacro.traverseMacro(ast, macroDefNodes, "MACRO_DEF");
        if (!macroDefNodes.isEmpty()) {
            String fname = ((PigParserNode)ast).getFileName();
            String msg = PigMacro.getErrorMessage(fname, ast.getLine(), "Invalide macro definition", "macro '" + this.name + "' contains macro definition.\nmacro content: " + this.body);
            throw new ParserException(msg);
        }
        PigParserNode pnode = (PigParserNode)tree;
        List<PigParserNode.InvocationPoint> invStack = pnode.getInvocationStack();
        ArrayList<PigParserNode.InvocationPoint> newInvStack = invStack == null ? new ArrayList<PigParserNode.InvocationPoint>() : new ArrayList<PigParserNode.InvocationPoint>(invStack);
        PigParserNode.InvocationPoint pt = new PigParserNode.InvocationPoint(line, file, this.name);
        newInvStack.add(pt);
        PigMacro.setInvocationStack(ast, newInvStack);
        ArrayList<CommonTree> inlineNodes = new ArrayList<CommonTree>();
        PigMacro.traverseMacro(ast, inlineNodes, "MACRO_INLINE");
        for (CommonTree t : inlineNodes) {
            CommonTree newTree = PigMacro.macroInline(t, new ArrayList<PigMacro>(this.seen.values()), this.macroStack);
            QueryParserUtils.replaceNodeWithNodeList(t, newTree, null);
        }
        CommonTreeNodeStream nodes = new CommonTreeNodeStream(ast);
        AliasMasker walker = new AliasMasker(nodes);
        walker.setParams(masks, this.name, this.idx++);
        AliasMasker.query_return result2 = null;
        CommonTree commonTree = null;
        try {
            result2 = walker.query();
        }
        catch (RecognitionException e) {
            String msg = walker.getErrorHeader(e) + " " + walker.getErrorMessage(e, walker.getTokenNames());
            String msg2 = PigMacro.getErrorMessage(file, line, "Failed to mask macro '" + this.name + "'", msg + "\nmacro content: " + in);
            throw new ParserException(msg2);
        }
        commonTree = result2.tree;
        LOG.debug((Object)("AST for masked macro '" + this.name + "':\n" + commonTree.toStringTree()));
        return commonTree;
    }

    private static void setInvocationStack(Tree ast, List<PigParserNode.InvocationPoint> stack) {
        PigParserNode node = (PigParserNode)ast;
        node.setInvocationStack(stack);
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            PigMacro.setInvocationStack(node.getChild(i), stack);
        }
    }

    void validate() throws IOException {
        if (this.rets.isEmpty()) {
            return;
        }
        HashSet<String> testSet = new HashSet<String>();
        StreamTokenizer st = new StreamTokenizer(new StringReader(this.body));
        st.wordChars(46, 46);
        st.wordChars(48, 57);
        st.wordChars(95, 95);
        st.wordChars(36, 36);
        st.lowerCaseMode(false);
        st.ordinaryChar(47);
        st.slashStarComments(true);
        while (st.nextToken() != -1) {
            if (PigMacro.matchWord(st, "define", false) && PigMacro.matchDollarAlias(st, true)) {
                testSet.add(st.sval.substring(1));
                continue;
            }
            if (PigMacro.matchDollarAlias(st, false)) {
                String prevWord = st.sval;
                if (PigMacro.matchWord(st, "if", true)) {
                    testSet.add(prevWord.substring(1));
                    continue;
                }
                if (PigMacro.matchChar(st, 61, true) && !PigMacro.matchChar(st, 61, true)) {
                    testSet.add(prevWord.substring(1));
                    continue;
                }
                if (!PigMacro.matchChar(st, 44, true)) continue;
                ArrayList<String> mlist = new ArrayList<String>();
                mlist.add(prevWord);
                if (!PigMacro.isMultiValueReturn(st, mlist, true)) continue;
                for (String s : mlist) {
                    testSet.add(s.substring(1));
                }
                continue;
            }
            if (!PigMacro.matchChar(st, 45, false) || !PigMacro.matchChar(st, 45, true)) continue;
            PigMacro.skipSingleLineComment(st);
        }
        for (String s : this.rets) {
            if (testSet.contains(s)) continue;
            throw new IOException("Macro '" + this.name + "' missing return alias: " + s);
        }
    }

    private static boolean isMultiValueReturn(StreamTokenizer st, List<String> mlist, boolean comma) throws IOException {
        int lookahead = st.nextToken();
        if (comma && lookahead == -3 || !comma && PigMacro.matchChar(st, 44, false)) {
            if (PigMacro.matchDollarAlias(st, false)) {
                mlist.add(st.sval);
            }
            return PigMacro.isMultiValueReturn(st, mlist, !comma);
        }
        return !comma && lookahead == 61 && !PigMacro.matchChar(st, 61, true);
    }

    private static boolean matchDollarAlias(StreamTokenizer st, boolean next) throws IOException {
        int type;
        int n = type = next ? st.nextToken() : st.ttype;
        if (type == -3 && st.sval.charAt(0) == '$' && st.sval.length() > 1) {
            return true;
        }
        if (next) {
            st.pushBack();
        }
        return false;
    }

    private static boolean matchWord(StreamTokenizer st, String word, boolean next) throws IOException {
        int type;
        int n = type = next ? st.nextToken() : st.ttype;
        if (type == -3 && st.sval.equalsIgnoreCase(word)) {
            return true;
        }
        if (next) {
            st.pushBack();
        }
        return false;
    }

    private static boolean matchChar(StreamTokenizer st, int c, boolean next) throws IOException {
        int type;
        int n = type = next ? st.nextToken() : st.ttype;
        if (type == c) {
            return true;
        }
        if (next) {
            st.pushBack();
        }
        return false;
    }

    private static void skipSingleLineComment(StreamTokenizer st) throws IOException {
        int lineNo = st.lineno();
        int lookahead = st.nextToken();
        while (lookahead != -1 && lookahead != 10 && st.lineno() <= lineNo) {
            lookahead = st.nextToken();
        }
        st.pushBack();
    }

    private static void traverseMacro(Tree t, List<CommonTree> nodes, String nodeType) {
        if (t.getText().equals(nodeType)) {
            nodes.add((CommonTree)t);
        }
        int n = t.getChildCount();
        for (int i = 0; i < n; ++i) {
            Tree t0 = t.getChild(i);
            PigMacro.traverseMacro(t0, nodes, nodeType);
        }
    }

    static CommonTree macroInline(CommonTree t, List<PigMacro> macroDefs, Set<String> macroStack) throws ParserException {
        String msg;
        String mn = t.getChild(0).getText();
        PigMacro macro = null;
        for (PigMacro pm : macroDefs) {
            if (!pm.getName().equals(mn)) continue;
            macro = pm;
            break;
        }
        String file = ((PigParserNode)t).getFileName();
        if (macro == null) {
            msg = PigMacro.getErrorMessage(file, t.getLine(), "Cannot expand macro '" + mn + "'", "Macro must be defined before expansion.");
            throw new ParserException(msg);
        }
        if (macroStack.contains(macro.name)) {
            msg = PigMacro.getErrorMessage(file, t.getLine(), "Cannot expand macro '" + mn + "'", "Macro can't be defined circularly.");
            throw new ParserException(msg);
        }
        HashSet<String> newStack = new HashSet<String>(macroStack);
        newStack.add(macro.name);
        macro.setStack(newStack);
        int n = t.getChild(1).getChildCount();
        String[] rets = new String[n];
        for (int i = 0; i < n; ++i) {
            rets[i] = t.getChild(1).getChild(i).getText();
        }
        int m = t.getChild(2).getChildCount();
        String[] params = new String[m];
        for (int i = 0; i < m; ++i) {
            params[i] = t.getChild(2).getChild(i).getText();
        }
        return macro.inline(params, rets, t, file);
    }

    private static String getErrorMessage(String file, int line, String header, String reason) {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        if (file != null) {
            sb.append("file ").append(file).append(", ");
        }
        sb.append("line ").append(line).append("> ").append(header);
        if (reason != null) {
            sb.append(". Reason: ").append(reason);
        }
        return sb.toString();
    }
}

