/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.executionengine.ExecJob;
import org.apache.pig.backend.hadoop.executionengine.HExecutionEngine;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.tools.grunt.GruntParser;
import org.apache.pig.tools.pigscript.parser.ParseException;
import org.apache.pig.tools.pigstats.PigStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InterfaceAudience.LimitedPrivate(value={"Penny"})
@InterfaceStability.Unstable
public class ToolsPigServer
extends PigServer {
    private PigPlans plans = null;

    public ToolsPigServer(String execTypeString) throws ExecException, IOException {
        super(execTypeString);
    }

    public ToolsPigServer(PigContext ctx) throws ExecException, IOException {
        super(ctx);
    }

    public ToolsPigServer(ExecType execType, Properties properties) throws ExecException {
        super(execType, properties);
    }

    public void registerNoRun(String fileName, Map<String, String> params, List<String> paramFiles) throws IOException, FrontendException {
        String substituted = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName);
            substituted = this.doParamSubstitution(fis, params, paramFiles);
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)e.getLocalizedMessage());
            throw new IOException(e.getCause());
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        try {
            GruntParser grunt = new GruntParser(new StringReader(substituted));
            grunt.setInteractive(false);
            grunt.setParams(this);
            this.setBatchOn();
            grunt.parseOnly();
        }
        catch (ParseException e) {
            this.log.error((Object)e.getLocalizedMessage());
            throw new IOException(e.getCause());
        }
        PigServer.Graph g = this.getClonedGraph();
        LogicalPlan lp = g.getPlan(null);
        this.plans = new PigPlans(lp);
    }

    public PigPlans getPlans() {
        return this.plans;
    }

    public List<ExecJob> runPlan(LogicalPlan newPlan, String jobName) throws FrontendException, ExecException {
        HExecutionEngine engine = new HExecutionEngine(this.pigContext);
        PhysicalPlan pp = engine.compile(newPlan, null);
        PigStats stats = this.launchPlan(pp, jobName);
        return this.getJobs(stats);
    }

    public static class PigPlans {
        public LogicalPlan lp;

        public PigPlans(LogicalPlan lp) {
            this.lp = lp;
        }
    }
}

