/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.grunt;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import jline.Completor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PigCompletor
implements Completor {
    private final Log log = LogFactory.getLog(this.getClass());
    Set<String> candidates = new TreeSet<String>();
    static final String AUTOCOMPLETE_FILENAME = "autocomplete";

    public PigCompletor() {
        try {
            InputStream keywordStream = null;
            try {
                keywordStream = new FileInputStream(AUTOCOMPLETE_FILENAME);
                PigCompletor.loadCandidateKeywords(keywordStream, this.candidates);
            }
            catch (FileNotFoundException e) {
                this.log.debug((Object)"Can not find autocomplete file in current directory, skipped");
            }
            Enumeration<URL> itr = this.getClass().getClassLoader().getResources(AUTOCOMPLETE_FILENAME);
            while (itr.hasMoreElements()) {
                URL url = itr.nextElement();
                keywordStream = url.openStream();
                if (PigCompletor.loadCandidateKeywords(keywordStream, this.candidates)) continue;
                this.log.debug((Object)("Error loading " + url + ", skipped"));
            }
            keywordStream = this.getClass().getResourceAsStream("/org/apache/pig/tools/grunt/autocomplete");
            PigCompletor.loadCandidateKeywords(keywordStream, this.candidates);
        }
        catch (IOException e) {
            this.log.warn((Object)"Error occurs when reading internal autocomplete file, skipped");
        }
    }

    public static boolean loadCandidateKeywords(InputStream stream, Set<String> candidates) throws IOException {
        String line;
        if (stream == null) {
            return false;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#") || line.startsWith("//") || (line = line.trim()).equals("")) continue;
            candidates.add(line);
        }
        reader.close();
        stream.close();
        return true;
    }

    @Override
    public int complete(String buffer, int cursor, List candidates) {
        List<String> matches;
        if (cursor == 0) {
            return -1;
        }
        int p = cursor;
        --p;
        while (p > 0) {
            char c = buffer.charAt(p);
            if (this.isDelimit(c)) {
                ++p;
                break;
            }
            --p;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = p; i < cursor; ++i) {
            sb.append(buffer.charAt(i));
        }
        if (!sb.toString().equals("") && (matches = this.searchCandidate(sb.toString())) != null) {
            if (matches.size() == 1) {
                candidates.add(matches.get(0) + " ");
            } else {
                for (String match : matches) {
                    candidates.add(match);
                }
            }
            return p;
        }
        return -1;
    }

    private boolean isDelimit(char c) {
        return Character.isWhitespace(c);
    }

    private List<String> searchCandidate(String s) {
        ArrayList<String> list = new ArrayList<String>();
        for (String can : this.candidates) {
            if (!can.startsWith(s)) continue;
            list.add(can);
        }
        return list;
    }
}

